/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PacketSetChiselMode
extends ModPacket {
    private IToolMode mode = ChiselMode.SINGLE;
    private ChiselToolType type = ChiselToolType.CHISEL;
    private boolean chatNotification = false;

    public PacketSetChiselMode(PacketBuffer buffer) {
        this.readPayload(buffer);
    }

    public PacketSetChiselMode(IToolMode mode, ChiselToolType type, boolean chatNotification) {
        this.mode = mode;
        this.type = type;
        this.chatNotification = chatNotification;
    }

    @Override
    public void server(ServerPlayerEntity player) {
        ItemStack ei = player.func_184614_ca();
        if (ei != null && ei.func_77973_b() instanceof IChiselModeItem) {
            IToolMode originalMode = this.type.getMode(ei);
            this.mode.setMode(ei);
            if (originalMode != this.mode && this.chatNotification) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(this.mode.getName().toString()), Util.field_240973_b_);
            }
        }
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        buffer.writeBoolean(this.chatNotification);
        buffer.func_179249_a((Enum)this.type);
        buffer.func_179249_a((Enum)((Object)this.mode));
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.chatNotification = buffer.readBoolean();
        this.type = (ChiselToolType)buffer.func_179257_a(ChiselToolType.class);
        if (this.type == ChiselToolType.BIT || this.type == ChiselToolType.CHISEL) {
            this.mode = (IToolMode)((Object)buffer.func_179257_a(ChiselMode.class));
        } else if (this.type == ChiselToolType.POSITIVEPATTERN) {
            this.mode = (IToolMode)((Object)buffer.func_179257_a(PositivePatternMode.class));
        } else if (this.type == ChiselToolType.TAPEMEASURE) {
            this.mode = (IToolMode)((Object)buffer.func_179257_a(TapeMeasureModes.class));
        }
    }

    public IToolMode getMode() {
        return this.mode;
    }

    public void setMode(IToolMode mode) {
        this.mode = mode;
    }

    public ChiselToolType getType() {
        return this.type;
    }

    public void setType(ChiselToolType type) {
        this.type = type;
    }

    public boolean isChatNotification() {
        return this.chatNotification;
    }

    public void setChatNotification(boolean chatNotification) {
        this.chatNotification = chatNotification;
    }
}

