/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import java.util.ArrayList;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselTypeIterator;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ContinousBits;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.helpers.VoxelRegionSrc;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PacketChisel
extends ModPacket {
    BitLocation from;
    BitLocation to;
    BitOperation place;
    Direction side;
    ChiselMode mode;
    Hand hand;

    public PacketChisel(PacketBuffer buffer) {
        this.readPayload(buffer);
    }

    public PacketChisel(BitOperation place, BitLocation from, BitLocation to, Direction side, ChiselMode mode, Hand hand) {
        this.place = place;
        this.from = BitLocation.min(from, to);
        this.to = BitLocation.max(from, to);
        this.side = side;
        this.mode = mode;
        this.hand = hand;
    }

    public PacketChisel(BitOperation place, BitLocation location, Direction side, ChiselMode mode, Hand hand) {
        this.place = place;
        this.from = this.to = location;
        this.side = side;
        this.mode = mode;
        this.hand = hand;
    }

    @Override
    public void server(ServerPlayerEntity playerEntity) {
        this.doAction((PlayerEntity)playerEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAction(PlayerEntity who) {
        World world = who.func_130014_f_();
        ActingPlayer player = ActingPlayer.actingAs(who, this.hand);
        int minX = Math.min(this.from.blockPos.func_177958_n(), this.to.blockPos.func_177958_n());
        int maxX = Math.max(this.from.blockPos.func_177958_n(), this.to.blockPos.func_177958_n());
        int minY = Math.min(this.from.blockPos.func_177956_o(), this.to.blockPos.func_177956_o());
        int maxY = Math.max(this.from.blockPos.func_177956_o(), this.to.blockPos.func_177956_o());
        int minZ = Math.min(this.from.blockPos.func_177952_p(), this.to.blockPos.func_177952_p());
        int maxZ = Math.max(this.from.blockPos.func_177952_p(), this.to.blockPos.func_177952_p());
        int returnVal = 0;
        boolean update = false;
        ItemStack extracted = null;
        ItemStack bitPlaced = null;
        ArrayList<ItemEntity> spawnlist = new ArrayList<ItemEntity>();
        UndoTracker.getInstance().beginGroup(who);
        try {
            for (int xOff = minX; xOff <= maxX; ++xOff) {
                for (int yOff = minY; yOff <= maxY; ++yOff) {
                    for (int zOff = minZ; zOff <= maxZ; ++zOff) {
                        TileEntityBlockChiseled te;
                        BlockPos pos = new BlockPos(xOff, yOff, zOff);
                        int placeStateID = this.place.usesBits() ? ItemChiseledBit.getStackState(who.func_184586_b(this.hand)) : 0;
                        ContinousChisels chisels = new ContinousChisels(player, pos, this.side);
                        ContinousBits bits = new ContinousBits(player, pos, placeStateID);
                        BlockState blkstate = world.func_180495_p(pos);
                        Block blkObj = blkstate.func_177230_c();
                        if (this.place.usesChisels() && (!chisels.isValid() || blkObj == null || blkstate == null || !ItemChisel.canMine(chisels, blkstate, who, world, pos)) || this.place.usesBits() && (!bits.isValid() || blkObj == null || blkstate == null) || world instanceof ServerWorld && world.func_73046_m() != null && world.func_73046_m().func_175579_a((ServerWorld)world, pos, player.getPlayer()) || !world.func_175660_a(player.getPlayer(), pos)) continue;
                        if (world.func_180495_p(pos).func_196953_a(new BlockItemUseContext(who, this.hand, ItemStack.field_190927_a, new BlockRayTraceResult(Vector3d.field_186680_a, Direction.NORTH, pos, false))) && this.place.usesBits()) {
                            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        }
                        BlockChiseled.ReplaceWithChiseledValue rv = null;
                        rv = BlockChiseled.replaceWithChiseled(world, pos, blkstate, placeStateID, true);
                        if (rv.success) {
                            blkstate = world.func_180495_p(pos);
                            blkObj = blkstate.func_177230_c();
                        }
                        TileEntityBlockChiseled tileEntityBlockChiseled = te = rv.te != null ? rv.te : ModUtil.getChiseledTileEntity(world, pos, this.place.usesBits());
                        if (!(te instanceof TileEntityBlockChiseled)) continue;
                        TileEntityBlockChiseled tec = te;
                        VoxelBlob mask = new VoxelBlob();
                        VoxelBlob vb = tec.getBlob();
                        ChiselIterator i = this.getIterator(new VoxelRegionSrc(world, pos, 1), pos, this.place);
                        while (i.hasNext()) {
                            if (this.place.usesChisels() && chisels.isValid() && (!this.place.usesBits() || vb.get(i.x(), i.y(), i.z()) != placeStateID)) {
                                extracted = ItemChisel.chiselBlock(chisels, player, vb, world, pos, i.side(), i.x(), i.y(), i.z(), extracted, spawnlist);
                            }
                            if (!this.place.usesBits() || !bits.isValid() || mask.get(i.x(), i.y(), i.z()) != 0) continue;
                            bitPlaced = bits.getItem(0).getStack();
                            update = ItemChiseledBit.placeBit(bits, player, vb, i.x(), i.y(), i.z()) || update;
                        }
                        if (update) {
                            tec.completeEditOperation(vb);
                            ++returnVal;
                            continue;
                        }
                        if (extracted == null) continue;
                        tec.completeEditOperation(vb);
                        ++returnVal;
                    }
                }
            }
            BitInventoryFeeder feeder = new BitInventoryFeeder(who, world);
            for (ItemEntity ei : spawnlist) {
                feeder.addItem(ei);
                ItemBitBag.cleanupInventory(who, ei.func_92059_d());
            }
            if (this.place.usesBits()) {
                ItemBitBag.cleanupInventory(who, bitPlaced != null ? bitPlaced : new ItemStack((IItemProvider)ModItems.ITEM_BLOCK_BIT.get(), 1));
            }
        }
        finally {
            UndoTracker.getInstance().endGroup(who);
        }
        return returnVal;
    }

    private ChiselIterator getIterator(VoxelRegionSrc vb, BlockPos pos, BitOperation place) {
        if (this.mode == ChiselMode.DRAWN_REGION) {
            int bitX = pos.func_177958_n() == this.from.blockPos.func_177958_n() ? this.from.bitX : 0;
            int bitY = pos.func_177956_o() == this.from.blockPos.func_177956_o() ? this.from.bitY : 0;
            int bitZ = pos.func_177952_p() == this.from.blockPos.func_177952_p() ? this.from.bitZ : 0;
            int scaleX = (pos.func_177958_n() == this.to.blockPos.func_177958_n() ? this.to.bitX : 15) - bitX + 1;
            int scaleY = (pos.func_177956_o() == this.to.blockPos.func_177956_o() ? this.to.bitY : 15) - bitY + 1;
            int scaleZ = (pos.func_177952_p() == this.to.blockPos.func_177952_p() ? this.to.bitZ : 15) - bitZ + 1;
            return new ChiselTypeIterator(16, bitX, bitY, bitZ, scaleX, scaleY, scaleZ, this.side);
        }
        return ChiselTypeIterator.create(16, this.from.bitX, this.from.bitY, this.from.bitZ, vb, this.mode, this.side, place.usePlacementOffset());
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.from = this.readBitLoc(buffer);
        this.to = this.readBitLoc(buffer);
        this.place = (BitOperation)buffer.func_179257_a(BitOperation.class);
        this.side = Direction.values()[buffer.readInt()];
        this.mode = ChiselMode.values()[buffer.readInt()];
        this.hand = Hand.values()[buffer.readInt()];
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        this.writeBitLoc(this.from, buffer);
        this.writeBitLoc(this.to, buffer);
        buffer.func_179249_a((Enum)this.place);
        buffer.writeInt(this.side.ordinal());
        buffer.writeInt(this.mode.ordinal());
        buffer.writeInt(this.hand.ordinal());
    }

    private BitLocation readBitLoc(PacketBuffer buffer) {
        return new BitLocation(buffer.func_179259_c(), buffer.readByte(), buffer.readByte(), buffer.readByte());
    }

    private void writeBitLoc(BitLocation from2, PacketBuffer buffer) {
        buffer.func_179255_a(from2.blockPos);
        buffer.writeByte(from2.bitX);
        buffer.writeByte(from2.bitY);
        buffer.writeByte(from2.bitZ);
    }
}

