/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.modes;

import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.modes.IToolMode;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;

public enum PositivePatternMode implements IToolMode
{
    REPLACE(LocalStrings.PositivePatternReplace),
    ADDITIVE(LocalStrings.PositivePatternAdditive),
    PLACEMENT(LocalStrings.PositivePatternPlacement),
    IMPOSE(LocalStrings.PositivePatternImpose);

    public final LocalStrings string;
    public boolean isDisabled = false;
    public Object binding;

    private PositivePatternMode(LocalStrings str) {
        this.string = str;
    }

    public static PositivePatternMode getMode(ItemStack stack) {
        if (stack != null) {
            try {
                CompoundNBT nbt = stack.func_77978_p();
                if (nbt != null && nbt.func_74764_b("mode")) {
                    return PositivePatternMode.valueOf(nbt.func_74779_i("mode"));
                }
            }
            catch (IllegalArgumentException nbt) {
            }
            catch (Exception e) {
                Log.logError("Unable to determine mode.", e);
            }
        }
        return REPLACE;
    }

    @Override
    public void setMode(ItemStack stack) {
        if (stack != null) {
            stack.func_77983_a("mode", (INBT)StringNBT.func_229705_a_((String)this.name()));
        }
    }

    public static PositivePatternMode castMode(IToolMode chiselMode) {
        if (chiselMode instanceof PositivePatternMode) {
            return (PositivePatternMode)chiselMode;
        }
        return REPLACE;
    }

    @Override
    public LocalStrings getName() {
        return this.string;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }
}

