/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.ItemStackSlot;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;

public class ContinousChisels
implements IContinuousInventory {
    private final ActingPlayer who;
    private final List<ItemStackSlot> options = new ArrayList<ItemStackSlot>();
    private final HashMap<Integer, List<ItemStackSlot>> actionCache = new HashMap();
    private final boolean canEdit;

    public ContinousChisels(@Nonnull ActingPlayer who, @Nonnull BlockPos pos, @Nonnull Direction side) {
        this.who = who;
        ItemStack inHand = who.getCurrentEquippedItem();
        IInventory inv = who.getInventory();
        this.canEdit = who.canPlayerManipulate(pos, side, new ItemStack((IItemProvider)ModItems.ITEM_CHISEL_DIAMOND.get(), 1), false);
        if (inHand != null && ModUtil.notEmpty(inHand) && inHand.func_77973_b() instanceof ItemChisel) {
            if (who.canPlayerManipulate(pos, side, inHand, false)) {
                this.options.add(new ItemStackSlot(inv, who.getCurrentItem(), inHand, who, this.canEdit));
            }
        } else {
            ArrayListMultimap discovered = ArrayListMultimap.create();
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack is = inv.func_70301_a(x);
                if (is == inHand || !who.canPlayerManipulate(pos, side, is, false) || is == null || !ModUtil.notEmpty(is) || !(is.func_77973_b() instanceof ItemChisel)) continue;
                IItemTier newMat = ((ItemChisel)is.func_77973_b()).func_200891_e();
                discovered.put((Object)newMat.func_200925_d(), (Object)new ItemStackSlot(inv, x, is, who, this.canEdit));
            }
            ArrayList allValues = Lists.newArrayList((Iterable)discovered.values());
            for (ItemStackSlot f : Lists.reverse((List)allValues)) {
                this.options.add(f);
            }
        }
    }

    @Override
    public IItemInInventory getItem(int BlockID) {
        List<ItemStackSlot> choices;
        if (!this.actionCache.containsKey(BlockID)) {
            this.actionCache.put(BlockID, new ArrayList<ItemStackSlot>(this.options));
        }
        if ((choices = this.actionCache.get(BlockID)).isEmpty()) {
            return new ItemStackSlot(this.who.getInventory(), -1, ModUtil.getEmptyStack(), this.who, this.canEdit);
        }
        IItemInInventory slot = choices.get(choices.size() - 1);
        if (slot.isValid()) {
            return slot;
        }
        this.fail(BlockID);
        return this.getItem(BlockID);
    }

    @Override
    public void fail(int BlockID) {
        List<ItemStackSlot> choices = this.actionCache.get(BlockID);
        if (!choices.isEmpty()) {
            choices.remove(choices.size() - 1);
        }
    }

    @Override
    public boolean isValid() {
        return !this.options.isEmpty() || this.who.isCreative();
    }

    @Override
    public boolean useItem(int blk) {
        this.getItem(blk).damage(this.who);
        return true;
    }
}

