/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedPatternJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedRecipeJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractRecipeGenerator
implements IDataProvider {
    private final DataGenerator generator;
    private final IForgeRegistryEntry<?> result;
    private DirectoryCache cache = null;

    protected AbstractRecipeGenerator(DataGenerator generator, Item result) {
        this.generator = generator;
        this.result = result;
    }

    protected AbstractRecipeGenerator(DataGenerator generator, Block result) {
        this.generator = generator;
        this.result = result;
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.cache = cache;
        this.generate();
    }

    protected abstract void generate() throws IOException;

    protected final void addShapedRecipe(String upperPart, String middlePart, String lowerPart, String keyOne, RecipeIngredientKeyJson ingOne) throws IOException {
        ShapedRecipeJson json = this.createShaped(upperPart, middlePart, lowerPart);
        json.setKey((Map)ImmutableMap.of((Object)keyOne, (Object)ingOne));
        this.save(json);
    }

    protected final void addShapedRecipe(String upperPart, String middlePart, String lowerPart, String keyOne, RecipeIngredientKeyJson ingOne, String keyTwo, RecipeIngredientKeyJson ingTwo) throws IOException {
        ShapedRecipeJson json = this.createShaped(upperPart, middlePart, lowerPart);
        json.setKey((Map)ImmutableMap.of((Object)keyOne, (Object)ingOne, (Object)keyTwo, (Object)ingTwo));
        this.save(json);
    }

    protected final void addShapedRecipe(String upperPart, String middlePart, String lowerPart, String keyOne, RecipeIngredientKeyJson ingOne, String keyTwo, RecipeIngredientKeyJson ingTwo, String keyThree, RecipeIngredientKeyJson ingThree) throws IOException {
        ShapedRecipeJson json = this.createShaped(upperPart, middlePart, lowerPart);
        json.setKey((Map)ImmutableMap.of((Object)keyOne, (Object)ingOne, (Object)keyTwo, (Object)ingTwo, (Object)keyThree, (Object)ingThree));
        this.save(json);
    }

    protected final void addShapedRecipe(String upperPart, String middlePart, String lowerPart, String keyOne, RecipeIngredientKeyJson ingOne, String keyTwo, RecipeIngredientKeyJson ingTwo, String keyThree, RecipeIngredientKeyJson ingThree, String keyFour, RecipeIngredientKeyJson ingFour) throws IOException {
        ShapedRecipeJson json = this.createShaped(upperPart, middlePart, lowerPart);
        json.setKey((Map)ImmutableMap.of((Object)keyOne, (Object)ingOne, (Object)keyTwo, (Object)ingTwo, (Object)keyThree, (Object)ingThree, (Object)keyFour, (Object)ingFour));
        this.save(json);
    }

    private ShapedRecipeJson createShaped(String upperPart, String middlePart, String lowerPart) {
        ShapedRecipeJson json = new ShapedRecipeJson();
        json.setGroup("chiselsandbits");
        json.setRecipeType(ShapedRecipeJson.getDefaultType());
        json.setPattern(new ShapedPatternJson(upperPart, middlePart, lowerPart));
        return json;
    }

    private void save(ShapedRecipeJson shapedRecipeJson) throws IOException {
        shapedRecipeJson.setResult(new RecipeResultJson(1, Objects.requireNonNull(this.result.getRegistryName()).toString()));
        Path recipeFolder = this.generator.func_200391_b().resolve("data/chiselsandbits/recipes/");
        Path recipePath = recipeFolder.resolve(Objects.requireNonNull(this.result.getRegistryName()).func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)this.cache, (JsonElement)shapedRecipeJson.serialize(), (Path)recipePath);
    }

    public final String func_200397_b() {
        return Objects.requireNonNull(this.result.getRegistryName()).toString() + " recipe generator";
    }
}

