/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.blockstate;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.MaterialType;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChiseledBlockBlockStateGenerator
implements IDataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new ChiseledBlockBlockStateGenerator(event.getGenerator()));
    }

    private ChiseledBlockBlockStateGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        for (MaterialType materialType : ModBlocks.VALID_CHISEL_MATERIALS) {
            RegistryObject<BlockChiseled> blockChiseledRegistryObject = ModBlocks.getMaterialToBlockConversions().get(materialType.getType());
            BlockChiseled blockChiseled = (BlockChiseled)blockChiseledRegistryObject.get();
            this.actOnBlock(cache, blockChiseled, materialType);
        }
    }

    public String func_200397_b() {
        return "Chiseled block blockstate generator";
    }

    public void actOnBlock(DirectoryCache cache, Block block, MaterialType type) throws IOException {
        HashMap variants = Maps.newHashMap();
        block.func_176194_O().func_177623_d().stream().forEach(property -> property.func_177700_c().forEach(value -> {
            String variantKey = String.format("%s=%s", property.func_177701_a(), value);
            String modelFile = Constants.DataGenerator.CHISELED_BLOCK_MODEL.toString();
            BlockstateModelJson model = new BlockstateModelJson(modelFile, 0, 0);
            variants.put(variantKey, new BlockstateVariantJson(model));
        }));
        BlockstateJson blockstateJson = new BlockstateJson((Map)variants);
        Path blockstateFolder = this.generator.func_200391_b().resolve("assets/chiselsandbits/blockstates/");
        Path blockstatePath = blockstateFolder.resolve("chiseled" + type.getName() + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)blockstateJson.serialize(), (Path)blockstatePath);
    }
}

