/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.client.ModConflictContext;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.core.api.IMCHandlerForceState;
import mod.chiselsandbits.core.api.IMCHandlerIgnoreLogic;
import mod.chiselsandbits.core.api.IMCHandlerKeyBinding;
import mod.chiselsandbits.core.api.IMCHandlerKeyBindingAnnotations;
import mod.chiselsandbits.core.api.IMCHandlerMaterialEquivilancy;
import mod.chiselsandbits.core.api.IMCMessageHandler;
import net.minecraftforge.fml.InterModComms;

public class IMCHandler {
    private final Map<String, IMCMessageHandler> processors = new HashMap<String, IMCMessageHandler>();

    public IMCHandler() {
        this.processors.put("forcestatecompatibility", new IMCHandlerForceState());
        this.processors.put("ignoreblocklogic", new IMCHandlerIgnoreLogic());
        this.processors.put("materialequivilancy", new IMCHandlerMaterialEquivilancy());
        for (ModConflictContext conflictContext : ModConflictContext.values()) {
            this.processors.put(conflictContext.getName(), new IMCHandlerKeyBinding());
        }
        this.processors.put("initkeybindingannotations", new IMCHandlerKeyBindingAnnotations());
    }

    public void handleIMCEvent() {
        InterModComms.getMessages((String)"chiselsandbits").forEach(this::executeIMC);
    }

    private void executeIMC(InterModComms.IMCMessage message) {
        IMCMessageHandler handler = this.processors.get(message.getMethod());
        if (handler != null) {
            handler.excuteIMC(message);
        } else {
            Log.logError("Invalid IMC: " + message.getMethod() + " from " + message.getSenderModId(), new RuntimeException("Invalid IMC Type."));
        }
    }
}

