/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import javax.annotation.Nullable;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;

public class BitBrush
implements IBitBrush {
    protected final int stateID;

    public BitBrush(int blockStateID) {
        this.stateID = blockStateID;
    }

    @Override
    public ItemStack getItemStack(int count) {
        if (this.stateID == 0) {
            return ModUtil.getEmptyStack();
        }
        return ItemChiseledBit.createStack(this.stateID, count, true);
    }

    @Override
    public boolean isAir() {
        return this.stateID == 0;
    }

    @Override
    @Nullable
    public BlockState getState() {
        if (this.stateID == 0) {
            return null;
        }
        return ModUtil.getStateById(this.stateID);
    }

    @Override
    public int getStateID() {
        return this.stateID;
    }
}

