/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.registry.ModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static Random RENDER_RANDOM = new Random();

    public static void drawSelectionBoundingBoxIfExists(MatrixStack matrixStack, AxisAlignedBB bb, BlockPos blockPos, PlayerEntity player, float partialTicks, boolean NormalBoundingBox) {
        RenderHelper.drawSelectionBoundingBoxIfExistsWithColor(matrixStack, bb, blockPos, player, partialTicks, NormalBoundingBox, 0, 0, 0, 102, 32);
    }

    public static void drawSelectionBoundingBoxIfExistsWithColor(MatrixStack matrixStack, AxisAlignedBB bb, BlockPos blockPos, PlayerEntity player, float partialTicks, boolean NormalBoundingBox, int red, int green, int blue, int alpha, int seeThruAlpha) {
        if (bb != null) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL11.glLineWidth((float)2.0f);
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            if (!NormalBoundingBox) {
                RenderHelper.renderBoundingBox(matrixStack, bb.func_72321_a(0.002, 0.002, 0.002).func_72317_d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), red, green, blue, alpha);
            }
            RenderSystem.disableDepthTest();
            RenderHelper.renderBoundingBox(matrixStack, bb.func_72321_a(0.002, 0.002, 0.002).func_72317_d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), red, green, blue, seeThruAlpha);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    public static void drawLineWithColor(MatrixStack matrixStack, Vector3d a, Vector3d b, BlockPos blockPos, PlayerEntity player, float partialTicks, boolean NormalBoundingBox, int red, int green, int blue, int alpha, int seeThruAlpha) {
        if (a != null && b != null) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL11.glLineWidth((float)2.0f);
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.shadeModel((int)7424);
            Vector3d a2 = a.func_72441_c((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            Vector3d b2 = b.func_72441_c((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            if (!NormalBoundingBox) {
                RenderHelper.renderLine(matrixStack, a2, b2, red, green, blue, alpha);
            }
            RenderSystem.disableDepthTest();
            RenderHelper.renderLine(matrixStack, a2, b2, red, green, blue, seeThruAlpha);
            RenderSystem.shadeModel((int)(Minecraft.func_71379_u() ? 7425 : 7424));
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    public static void renderQuads(MatrixStack matrixStack, int alpha, BufferBuilder renderer, List<BakedQuad> quads, World worldObj, BlockPos blockPos, int combinedLightIn, int combinedOverlayIn) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int color = bakedquad.func_178211_c() == -1 ? alpha | 0xFFFFFF : RenderHelper.getTint(alpha, bakedquad.func_178211_c(), worldObj, blockPos);
            float cb = color & 0xFF;
            float cg = color >>> 8 & 0xFF;
            float cr = color >>> 16 & 0xFF;
            float ca = color >>> 24 & 0xFF;
            renderer.addVertexData(matrixStack.func_227866_c_(), bakedquad, cb, cg, cr, ca, combinedLightIn, combinedOverlayIn, false);
        }
    }

    public static void renderBoundingBox(MatrixStack matrixStack, AxisAlignedBB boundingBox, int red, int green, int blue, int alpha) {
        GL11.glPushAttrib((int)8256);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        RenderSystem.shadeModel((int)7424);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        float minX = (float)boundingBox.field_72340_a;
        float minY = (float)boundingBox.field_72338_b;
        float minZ = (float)boundingBox.field_72339_c;
        float maxX = (float)boundingBox.field_72336_d;
        float maxY = (float)boundingBox.field_72337_e;
        float maxZ = (float)boundingBox.field_72334_f;
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, minY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, minY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, minY, maxZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, minY, maxZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, minY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, maxY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, maxY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, maxY, maxZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, maxY, maxZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, maxY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, minY, minZ).func_225586_a_(red, green, blue, 0).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, maxY, minZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, minY, maxZ).func_225586_a_(red, green, blue, 0).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), minX, maxY, maxZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, minY, maxZ).func_225586_a_(red, green, blue, 0).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), maxX, maxY, maxZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glPopAttrib();
    }

    public static void renderLine(MatrixStack matrixStack, Vector3d a, Vector3d b, int red, int green, int blue, int alpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        RenderSystem.shadeModel((int)7424);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)a.field_72450_a, (float)a.field_72448_b, (float)a.field_72449_c).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)b.field_72450_a, (float)b.field_72448_b, (float)b.field_72449_c).func_225586_a_(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
    }

    public static int getTint(int alpha, int tintIndex, World worldObj, BlockPos blockPos) {
        return alpha | Minecraft.func_71410_x().func_184125_al().func_228054_a_(ModBlocks.getChiseledDefaultState(), (IBlockDisplayReader)worldObj, blockPos, tintIndex);
    }

    public static void renderModel(MatrixStack matrixStack, IBakedModel model, World worldObj, BlockPos blockPos, int alpha, int combinedLightmap, int combinedOverlay) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (Direction enumfacing : Direction.values()) {
            RenderHelper.renderQuads(matrixStack, alpha, buffer, model.func_200117_a(null, enumfacing, RENDER_RANDOM), worldObj, blockPos, combinedLightmap, combinedOverlay);
        }
        RenderHelper.renderQuads(matrixStack, alpha, buffer, model.func_200117_a(null, null, RENDER_RANDOM), worldObj, blockPos, combinedLightmap, combinedOverlay);
        tessellator.func_78381_a();
    }

    public static void renderGhostModel(MatrixStack matrixStack, IBakedModel baked, World worldObj, BlockPos blockPos, boolean isUnplaceable, int combinedLightmap, int combinedOverlay) {
        int alpha = isUnplaceable ? 0x22000000 : -1442840576;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderHelper.renderModel(matrixStack, baked, worldObj, blockPos, alpha, combinedLightmap, combinedOverlay);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderHelper.renderModel(matrixStack, baked, worldObj, blockPos, alpha, combinedLightmap, combinedOverlay);
        RenderSystem.disableBlend();
    }
}

