/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.client.ClipboardStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class CreativeClipboardTab
extends ItemGroup
implements ICacheClearable {
    static boolean renewMappings = true;
    private static List<ItemStack> myWorldItems = new ArrayList<ItemStack>();
    private static List<CompoundNBT> myCrossItems = new ArrayList<CompoundNBT>();
    private static ClipboardStorage clipStorage = null;

    public static void load(File file) {
        clipStorage = new ClipboardStorage(file);
        myCrossItems = clipStorage.read();
    }

    public static void addItem(ItemStack iss) {
        if (EffectiveSide.get().isClient()) {
            IBitAccess bitData = ChiselsAndBits.getApi().createBitItem(iss);
            if (bitData == null) {
                return;
            }
            ItemStack is = bitData.getBitsAsItem(null, ItemType.CHISLED_BLOCK, true);
            if (is == null) {
                return;
            }
            for (CompoundNBT isa : myCrossItems) {
                if (!isa.equals((Object)is.func_77978_p())) continue;
                myCrossItems.remove(isa);
                break;
            }
            myCrossItems.add(0, is.func_77978_p());
            while (myCrossItems.size() > (Integer)ChiselsAndBits.getConfig().getServer().creativeClipboardSize.get() && !myCrossItems.isEmpty()) {
                myCrossItems.remove(myCrossItems.size() - 1);
            }
            clipStorage.write(myCrossItems);
            myWorldItems.clear();
            renewMappings = true;
        }
    }

    public CreativeClipboardTab() {
        super("chiselsandbits.Clipboard");
        ChiselsAndBits.getInstance().addClearable(this);
    }

    public ItemStack func_78016_d() {
        return new ItemStack((IItemProvider)ModItems.ITEM_MIRROR_PRINT_WRITTEN.get());
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        if (renewMappings) {
            myWorldItems.clear();
            renewMappings = false;
            for (CompoundNBT nbt : myCrossItems) {
                NBTBlobConverter c = new NBTBlobConverter();
                c.readChisleData(nbt.func_74775_l("BlockEntityTag"), -1);
                c.updateFromBlob();
                ItemStack worldItem = c.getItemStack(false);
                if (worldItem == null) continue;
                myWorldItems.add(worldItem);
            }
        }
        items.addAll(myWorldItems);
    }

    @Override
    public void clearCache() {
        renewMappings = true;
    }
}

