/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import mod.chiselsandbits.api.StateCount;
import mod.chiselsandbits.api.VoxelStats;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelType;
import mod.chiselsandbits.chiseledblock.serialization.BitStream;
import mod.chiselsandbits.chiseledblock.serialization.BlobSerializer;
import mod.chiselsandbits.chiseledblock.serialization.BlobSerilizationCache;
import mod.chiselsandbits.chiseledblock.serialization.CrossWorldBlobSerializer;
import mod.chiselsandbits.chiseledblock.serialization.PalettedBlobSerializer;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.IVoxelSrc;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

public final class VoxelBlob
implements IVoxelSrc {
    private static final BitSet fluidFilterState;
    private static final Map<Object, BitSet> layerFilters;
    static final int SHORT_BYTES = 2;
    public static final int dim = 16;
    public static final int dim2 = 256;
    public static final int full_size = 4096;
    public static final int dim_minus_one = 15;
    private static final int array_size = 4096;
    public static VoxelBlob NULL_BLOB;
    final int[] values = new int[4096];
    final BitSet noneAir;
    public int detail = 16;
    public static final int VERSION_ANY = -1;
    private static final int VERSION_COMPACT = 0;
    private static final int VERSION_CROSSWORLD_LEGACY = 1;
    public static final int VERSION_CROSSWORLD = 2;
    public static final int VERSION_COMPACT_PALLETED = 3;
    static int bestBufferSize;

    public static synchronized void clearCache() {
        fluidFilterState.clear();
        ForgeRegistry blockReg = (ForgeRegistry)ForgeRegistries.BLOCKS;
        for (Block block : blockReg) {
            block.func_176194_O().func_177619_a().forEach(blockState -> {
                int stateId = ModUtil.getStateId(blockState);
                if (BlockBitInfo.getTypeFromStateID(stateId) == VoxelType.FLUID) {
                    fluidFilterState.set(stateId);
                }
            });
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            VoxelBlob.updateCacheClient();
            ModUtil.cacheFastStates();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateCacheClient() {
        int id;
        layerFilters.clear();
        Map<Object, BitSet> layerFilters = VoxelBlob.layerFilters;
        for (RenderType layer : RenderType.func_228661_n_()) {
            layerFilters.put(layer, new BitSet(4096));
        }
        ForgeRegistry blockReg = (ForgeRegistry)ForgeRegistries.BLOCKS;
        for (Block block : blockReg) {
            if (block instanceof FlowingFluidBlock) continue;
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                id = ModUtil.getStateId(state);
                if (state == null || state.func_177230_c() != block) continue;
                for (RenderType layer : RenderType.func_228661_n_()) {
                    if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
                    layerFilters.get(layer).set(id);
                }
            }
        }
        for (Fluid fluid : ForgeRegistries.FLUIDS) {
            for (BlockState state : fluid.func_207182_e().func_177619_a()) {
                id = ModUtil.getStateId(state.func_206883_i());
                for (RenderType layer : RenderType.func_228661_n_()) {
                    if (!RenderTypeLookup.canRenderInLayer((FluidState)state, (RenderType)layer)) continue;
                    layerFilters.get(layer).set(id);
                }
            }
        }
    }

    public VoxelBlob() {
        this.noneAir = new BitSet(4096);
    }

    public BitSet getNoneAir() {
        return this.noneAir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VoxelBlob)) {
            return false;
        }
        VoxelBlob voxelBlob = (VoxelBlob)o;
        return this.detail == voxelBlob.detail && Arrays.equals(this.values, voxelBlob.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.detail);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public VoxelBlob(VoxelBlob vb) {
        for (int x = 0; x < this.values.length; ++x) {
            this.values[x] = vb.values[x];
        }
        this.noneAir = (BitSet)vb.noneAir.clone();
    }

    public boolean canMerge(VoxelBlob second) {
        int[] sv = second.values;
        for (int x = 0; x < this.values.length; ++x) {
            if (this.values[x] == 0 || sv[x] == 0 || this.values[x] == sv[x]) continue;
            return false;
        }
        return true;
    }

    public VoxelBlob merge(VoxelBlob second) {
        VoxelBlob out = new VoxelBlob();
        int[] secondValues = second.values;
        BitSet secondNoneAir = second.noneAir;
        int[] ov = out.values;
        BitSet ona = out.noneAir;
        for (int x = 0; x < this.values.length; ++x) {
            int firstValue = this.values[x];
            ov[x] = firstValue == 0 ? secondValues[x] : firstValue;
            ona.set(x, firstValue == 0 ? secondNoneAir.get(x) : this.noneAir.get(x));
        }
        return out;
    }

    public VoxelBlob mirror(Direction.Axis axis) {
        VoxelBlob out = new VoxelBlob();
        BitIterator bi = new BitIterator();
        block5: while (bi.hasNext()) {
            if (bi.getNext(this) == 0) continue;
            switch (axis) {
                case X: {
                    out.set(15 - bi.x, bi.y, bi.z, bi.getNext(this));
                    continue block5;
                }
                case Y: {
                    out.set(bi.x, 15 - bi.y, bi.z, bi.getNext(this));
                    continue block5;
                }
                case Z: {
                    out.set(bi.x, bi.y, 15 - bi.z, bi.getNext(this));
                    continue block5;
                }
            }
            throw new NullPointerException();
        }
        return out;
    }

    public BlockPos getCenter() {
        boolean found = false;
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            if (bi.getNext(this) == 0) continue;
            if (found) {
                min_x = Math.min(min_x, bi.x);
                min_y = Math.min(min_y, bi.y);
                min_z = Math.min(min_z, bi.z);
                max_x = Math.max(max_x, bi.x);
                max_y = Math.max(max_y, bi.y);
                max_z = Math.max(max_z, bi.z);
                continue;
            }
            found = true;
            min_x = bi.x;
            min_y = bi.y;
            min_z = bi.z;
            max_x = bi.x;
            max_y = bi.y;
            max_z = bi.z;
        }
        return found ? new BlockPos((min_x + max_x) / 2, (min_y + max_y) / 2, (min_z + max_z) / 2) : null;
    }

    public IntegerBox getBounds() {
        boolean found = false;
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            if (bi.getNext(this) == 0) continue;
            if (found) {
                min_x = Math.min(min_x, bi.x);
                min_y = Math.min(min_y, bi.y);
                min_z = Math.min(min_z, bi.z);
                max_x = Math.max(max_x, bi.x);
                max_y = Math.max(max_y, bi.y);
                max_z = Math.max(max_z, bi.z);
                continue;
            }
            found = true;
            min_x = bi.x;
            min_y = bi.y;
            min_z = bi.z;
            max_x = bi.x;
            max_y = bi.y;
            max_z = bi.z;
        }
        return found ? new IntegerBox(min_x, min_y, min_z, max_x, max_y, max_z) : null;
    }

    public VoxelBlob spin(Direction.Axis axis) {
        VoxelBlob d = new VoxelBlob();
        BitIterator bi = new BitIterator();
        block5: while (bi.hasNext()) {
            switch (axis) {
                case X: {
                    d.set(bi.x, 15 - bi.z, bi.y, bi.getNext(this));
                    continue block5;
                }
                case Y: {
                    int blockStateId = bi.getNext(this);
                    BlockState blockState = ModUtil.getStateById(blockStateId);
                    BlockState rotatedBlockState = blockState.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
                    d.set(bi.z, bi.y, 15 - bi.x, ModUtil.getStateId(rotatedBlockState));
                    continue block5;
                }
                case Z: {
                    d.set(15 - bi.y, bi.x, bi.z, bi.getNext(this));
                    continue block5;
                }
            }
            throw new NullPointerException();
        }
        return d;
    }

    public void fillAmount(int value, int amount) {
        int loopCount = Math.max(0, Math.min(amount, 4096));
        if (loopCount == 0) {
            return;
        }
        this.noneAir.clear();
        for (int x = 0; x < loopCount; ++x) {
            this.values[x] = value;
            this.noneAir.set(x, value > 0);
        }
    }

    public void fillAmountFromBottom(int value, int amount) {
        int loopCount = Math.max(0, Math.min(amount, 4096));
        if (loopCount == 0) {
            return;
        }
        this.noneAir.clear();
        int count = 0;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int i = VoxelBlob.getDataIndex(x, y, z);
                    this.values[i] = value;
                    this.noneAir.set(i, value > 0);
                    if (++count != amount) continue;
                    return;
                }
            }
        }
    }

    public void fill(int value) {
        this.noneAir.clear();
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = value;
            this.noneAir.set(x, value > 0);
        }
    }

    public void fill(VoxelBlob src) {
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = src.values[x];
        }
        this.noneAir.clear();
        this.noneAir.or(src.noneAir);
    }

    public void fillNoneAir(int value) {
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] == 0) continue;
            this.values[x] = value;
            this.noneAir.set(x, value > 0);
        }
    }

    public PartialFillResult clearAllBut(int firstState, int secondState, int thirdState) {
        int firstStateUseCount = 0;
        int secondStateUseCount = 0;
        int thirdStateUseCount = 0;
        for (int x = 0; x < 4096; ++x) {
            if (!(this.values[x] == 0 || firstState != 0 && this.values[x] == firstState || secondState != 0 && this.values[x] == secondState || thirdState != 0 && this.values[x] == thirdState)) {
                this.values[x] = 0;
                this.noneAir.set(x, true);
            }
            if (this.values[x] == firstState && firstState != 0) {
                ++firstStateUseCount;
            }
            if (this.values[x] == secondState && secondState != 0) {
                ++secondStateUseCount;
            }
            if (this.values[x] != thirdState || thirdState == 0) continue;
            ++thirdStateUseCount;
        }
        return new PartialFillResult(firstStateUseCount, secondStateUseCount, thirdStateUseCount);
    }

    public void clear() {
        this.fill(0);
    }

    public int air() {
        int p = 0;
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] != 0) continue;
            ++p;
        }
        return p;
    }

    public void binaryReplacement(int airReplacement, int solidReplacement) {
        this.noneAir.clear();
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = this.values[x] == 0 ? airReplacement : solidReplacement;
            this.noneAir.set(x, this.values[x] > 0);
        }
    }

    public int filled() {
        int p = 0;
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] == 0) continue;
            ++p;
        }
        return p;
    }

    protected int getBit(int offset) {
        if (offset < 0 || offset >= this.values.length) {
            return 0;
        }
        return this.values[offset];
    }

    protected void putBit(int offset, int newValue) {
        this.values[offset] = newValue;
        this.noneAir.set(offset, newValue > 0);
    }

    public int get(int x, int y, int z) {
        return this.getBit(VoxelBlob.getDataIndex(x, y, z));
    }

    public static int getDataIndex(int x, int y, int z) {
        return x | y << 4 | z << 8;
    }

    public VoxelType getVoxelType(int x, int y, int z) {
        return BlockBitInfo.getTypeFromStateID(this.get(x, y, z));
    }

    public void set(int x, int y, int z, int value) {
        this.putBit(x | y << 4 | z << 8, value);
    }

    public void clear(int x, int y, int z) {
        this.putBit(x | y << 4 | z << 8, 0);
    }

    private void legacyRead(ByteArrayInputStream o) throws IOException {
        GZIPInputStream w = new GZIPInputStream(o);
        ByteBuffer bb = ByteBuffer.allocate(this.values.length * 2);
        w.read(bb.array());
        ShortBuffer src = bb.asShortBuffer();
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = this.fixShorts(src.get());
            this.noneAir.set(x, this.values[x] > 0);
        }
        w.close();
    }

    private int fixShorts(short s) {
        return s & 0xFFFF;
    }

    private void legacyWrite(ByteArrayOutputStream o) {
        try {
            GZIPOutputStream w = new GZIPOutputStream(o);
            ByteBuffer bb = ByteBuffer.allocate(this.values.length * 2);
            ShortBuffer sb = bb.asShortBuffer();
            for (int x = 0; x < 4096; ++x) {
                sb.put((short)this.values[x]);
            }
            w.write(bb.array());
            w.finish();
            w.close();
            o.close();
        }
        catch (IOException e) {
            Log.logError("Unable to write blob.", e);
            throw new RuntimeException(e);
        }
    }

    public byte[] toLegacyByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.legacyWrite(out);
        return out.toByteArray();
    }

    public void fromLegacyByteArray(byte[] i) throws IOException {
        ByteArrayInputStream out = new ByteArrayInputStream(i);
        this.legacyRead(out);
    }

    @Override
    public int getSafe(int x, int y, int z) {
        if (x >= 0 && x < 16 && y >= 0 && y < 16 && z >= 0 && z < 16) {
            return this.get(x, y, z);
        }
        return 0;
    }

    public void visibleFace(Direction face, int x, int y, int z, VisibleFace dest, ICullTest cullVisTest) {
        int mySpot;
        dest.state = mySpot = this.get(x, y, z);
        if ((x += face.func_82601_c()) >= 0 && x < 16 && (y += face.func_96559_d()) >= 0 && y < 16 && (z += face.func_82599_e()) >= 0 && z < 16) {
            dest.isEdge = false;
            dest.visibleFace = cullVisTest.isVisible(mySpot, this.get(x, y, z));
        } else {
            dest.isEdge = true;
            dest.visibleFace = mySpot != 0;
        }
    }

    public Map<Integer, Integer> getBlockSums() {
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        int lastType = this.values[0];
        int firstOfType = 0;
        for (int x = 1; x < 4096; ++x) {
            int v = this.values[x];
            if (lastType == v) continue;
            Integer sumx = (Integer)counts.get(lastType);
            if (sumx == null) {
                counts.put(lastType, x - firstOfType);
            } else {
                counts.put(lastType, sumx + (x - firstOfType));
            }
            firstOfType = x;
            lastType = v;
        }
        Integer sumx = (Integer)counts.get(lastType);
        if (sumx == null) {
            counts.put(lastType, 4096 - firstOfType);
        } else {
            counts.put(lastType, sumx + (4096 - firstOfType));
        }
        return counts;
    }

    public List<StateCount> getStateCounts() {
        Map<Integer, Integer> count = this.getBlockSums();
        ArrayList<StateCount> out = new ArrayList<StateCount>(count.size());
        for (Map.Entry<Integer, Integer> o : count.entrySet()) {
            out.add(new StateCount(o.getKey(), o.getValue()));
        }
        return out;
    }

    public VoxelStats getVoxelStats() {
        VoxelStats cb = new VoxelStats();
        cb.isNormalBlock = true;
        int nonAirBits = 0;
        for (Map.Entry<Integer, Integer> o : this.getBlockSums().entrySet()) {
            BlockState state;
            int quantity = o.getValue();
            int r = o.getKey();
            if (quantity > cb.mostCommonStateTotal && r != 0) {
                cb.mostCommonState = r;
                cb.mostCommonStateTotal = quantity;
            }
            if ((state = ModUtil.getStateById(r)) == null || r == 0) continue;
            nonAirBits += quantity;
            cb.isNormalBlock = cb.isNormalBlock && ModUtil.isNormalCube(state);
            cb.blockLight += (float)(quantity * DeprecationHelper.getLightValue(state));
        }
        cb.isFullBlock = cb.mostCommonStateTotal == 4096;
        cb.isNormalBlock = cb.isNormalBlock && 4096 == nonAirBits;
        float light_size = (float)((Double)ChiselsAndBits.getConfig().getServer().bitLightPercentage.get() * 4096.0 * 15.0 / 100.0);
        cb.blockLight /= light_size;
        return cb;
    }

    public VoxelBlob offset(int xx, int yy, int zz) {
        VoxelBlob out = new VoxelBlob();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    out.set(x, y, z, this.getSafe(x - xx, y - yy, z - zz));
                }
            }
        }
        return out;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> listContents(List<ITextComponent> details) {
        HashMap<Integer, Integer> states = new HashMap<Integer, Integer>();
        HashMap<ITextComponent, Integer> contents = new HashMap<ITextComponent, Integer>();
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            int state = bi.getNext(this);
            if (state == 0) continue;
            Integer count = (Integer)states.get(state);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            states.put(state, count);
        }
        for (Map.Entry e : states.entrySet()) {
            ITextComponent name = ItemChiseledBit.getBitTypeName(ItemChiseledBit.createStack((Integer)e.getKey(), 1, false));
            if (name == null) continue;
            Integer count = (Integer)contents.get(name);
            count = count == null ? (Integer)e.getValue() : Integer.valueOf(count + (Integer)e.getValue());
            contents.put(name, count);
        }
        if (contents.isEmpty()) {
            details.add((ITextComponent)new StringTextComponent(LocalStrings.Empty.getLocal()));
        }
        for (Map.Entry e : contents.entrySet()) {
            details.add((ITextComponent)new StringTextComponent("" + e.getValue() + ' ').func_230529_a_((ITextComponent)e.getKey()));
        }
        return details;
    }

    public int getSideFlags(int minRange, int maxRange, int totalRequired) {
        int output = 0;
        for (Direction face : Direction.values()) {
            int edge = face.func_176743_c() == Direction.AxisDirection.POSITIVE ? 15 : 0;
            int required = totalRequired;
            switch (face.func_176740_k()) {
                case X: {
                    int z;
                    for (z = minRange; z <= maxRange; ++z) {
                        for (int y = minRange; y <= maxRange; ++y) {
                            if (this.getVoxelType(edge, y, z) != VoxelType.SOLID) continue;
                            --required;
                        }
                    }
                    break;
                }
                case Y: {
                    int x;
                    int z;
                    for (z = minRange; z <= maxRange; ++z) {
                        for (x = minRange; x <= maxRange; ++x) {
                            if (this.getVoxelType(x, edge, z) != VoxelType.SOLID) continue;
                            --required;
                        }
                    }
                    break;
                }
                case Z: {
                    int x;
                    for (int y = minRange; y <= maxRange; ++y) {
                        for (x = minRange; x <= maxRange; ++x) {
                            if (this.getVoxelType(x, y, edge) != VoxelType.SOLID) continue;
                            --required;
                        }
                    }
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
            if (required > 0) continue;
            output |= 1 << face.ordinal();
        }
        return output;
    }

    public static boolean isFluid(int ref) {
        return fluidFilterState.get(ref & 0xFFFF);
    }

    public boolean filterFluids(boolean wantsFluids) {
        boolean hasValues = false;
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            if (ref == 0) continue;
            if (fluidFilterState.get(ref) != wantsFluids) {
                this.values[x] = 0;
                this.noneAir.clear(x);
                continue;
            }
            hasValues = true;
        }
        return hasValues;
    }

    public boolean filter(RenderType layer) {
        BitSet layerFilterState = layerFilters.get(layer);
        boolean hasValues = false;
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            if (ref == 0) continue;
            if (!layerFilterState.get(ref)) {
                this.values[x] = 0;
                this.noneAir.clear(x);
                continue;
            }
            hasValues = true;
        }
        return hasValues;
    }

    public void blobFromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream out = new ByteArrayInputStream(bytes);
        this.read(out);
    }

    private void read(ByteArrayInputStream o) throws IOException, RuntimeException {
        InflaterInputStream w = new InflaterInputStream(o);
        ByteBuffer bb = BlobSerilizationCache.getCacheBuffer();
        int usedBytes = 0;
        int rv = 0;
        while ((rv = w.read(bb.array(), usedBytes += rv, bb.limit() - usedBytes)) > 0) {
        }
        PacketBuffer header = new PacketBuffer(Unpooled.wrappedBuffer((ByteBuffer)bb));
        int version = header.readInt();
        BlobSerializer bs = null;
        if (version == 0) {
            bs = new BlobSerializer(header);
        } else if (version == 3) {
            bs = new PalettedBlobSerializer(header);
        } else if (version == 2) {
            bs = new CrossWorldBlobSerializer(header);
        } else {
            throw new RuntimeException("Invalid Version: " + version);
        }
        int byteOffset = header.readInt();
        int bytesOfInterest = header.readInt();
        BitStream bits = BitStream.valueOf(byteOffset, ByteBuffer.wrap(bb.array(), header.readerIndex(), bytesOfInterest));
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = bs.readVoxelStateID(bits);
            this.noneAir.set(x, this.values[x] > 0);
        }
        w.close();
    }

    public byte[] blobToBytes(int version) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(bestBufferSize);
        this.write(out, this.getSerializer(version));
        byte[] o = out.toByteArray();
        if (bestBufferSize < o.length) {
            bestBufferSize = o.length;
        }
        return o;
    }

    private BlobSerializer getSerializer(int version) {
        if (version == 0) {
            return new BlobSerializer(this);
        }
        if (version == 3) {
            return new PalettedBlobSerializer(this);
        }
        if (version == 2) {
            return new CrossWorldBlobSerializer(this);
        }
        throw new RuntimeException("Invalid Version: " + version);
    }

    private void write(ByteArrayOutputStream o, BlobSerializer bs) {
        try {
            Deflater def = BlobSerilizationCache.getCacheDeflater();
            DeflaterOutputStream w = new DeflaterOutputStream((OutputStream)o, def, bestBufferSize);
            PacketBuffer pb = BlobSerilizationCache.getCachePacketBuffer();
            pb.writeInt(bs.getVersion());
            bs.write(pb);
            BitStream set = BlobSerilizationCache.getCacheBitStream();
            for (int x = 0; x < 4096; ++x) {
                bs.writeVoxelState(this.values[x], set);
            }
            byte[] arrayContents = set.toByteArray();
            int bytesToWrite = arrayContents.length;
            int byteOffset = set.byteOffset();
            pb.writeInt(byteOffset);
            pb.writeInt(bytesToWrite - byteOffset);
            w.write(pb.array(), 0, pb.writerIndex());
            w.write(arrayContents, byteOffset, bytesToWrite - byteOffset);
            w.finish();
            w.close();
            def.reset();
            o.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        layerFilters = new HashMap<Object, BitSet>();
        fluidFilterState = new BitSet(4096);
        VoxelBlob.clearCache();
        NULL_BLOB = new VoxelBlob();
        bestBufferSize = 26;
    }

    public static class PartialFillResult {
        private final int firstStateUsedCount;
        private final int secondStateUsedCount;
        private final int thirdStateUsedCount;

        public PartialFillResult(int firstStateUsedCount, int secondStateUsedCount, int thirdStateUsedCount) {
            this.firstStateUsedCount = firstStateUsedCount;
            this.secondStateUsedCount = secondStateUsedCount;
            this.thirdStateUsedCount = thirdStateUsedCount;
        }

        public int getFirstStateUsedCount() {
            return this.firstStateUsedCount;
        }

        public int getSecondStateUsedCount() {
            return this.secondStateUsedCount;
        }

        public int getThirdStateUsedCount() {
            return this.thirdStateUsedCount;
        }
    }

    public static class VisibleFace {
        public boolean isEdge;
        public boolean visibleFace;
        public int state;
    }
}

