/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.io.IOException;
import mod.chiselsandbits.api.VoxelStats;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.serialization.StringStates;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.registry.ModBlocks;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;

public class NBTBlobConverter {
    public static final String NBT_SIDE_FLAGS = "s";
    public static final String NBT_NORMALCUBE_FLAG = "nc";
    public static final String NBT_LIGHTVALUE = "lv";
    public static final String NBT_PRIMARY_STATE = "b";
    public static final String NBT_LEGACY_VOXEL = "v";
    public static final String NBT_VERSIONED_VOXEL = "X";
    TileEntityBlockChiseled tile;
    private int sideState;
    private int lightValue;
    private boolean isNormalCube;
    private int primaryBlockState;
    private VoxelBlobStateReference voxelBlobRef;
    private int format = -1;
    private final boolean triggerUpdates;

    public int getSideState() {
        return this.sideState;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public boolean isNormalCube() {
        return this.isNormalCube;
    }

    public int getPrimaryBlockStateID() {
        return this.primaryBlockState;
    }

    public BlockState getPrimaryBlockState() {
        return ModUtil.getStateById(this.primaryBlockState);
    }

    public VoxelBlobStateReference getVoxelRef(int version, long weight) throws Exception {
        VoxelBlobStateReference voxelRef = this.getRef();
        if (this.format == version) {
            return new VoxelBlobStateReference(voxelRef.getByteArray(), weight);
        }
        return new VoxelBlobStateReference(voxelRef.getVoxelBlobCatchable().blobToBytes(version), weight);
    }

    public NBTBlobConverter() {
        this.triggerUpdates = false;
    }

    public NBTBlobConverter(boolean triggerBlockUpdates, TileEntityBlockChiseled tile) {
        this.tile = tile;
        this.triggerUpdates = triggerBlockUpdates;
        this.sideState = tile.sideState;
        this.lightValue = tile.getLightValue();
        this.isNormalCube = tile.isNormalCube;
        this.primaryBlockState = ModUtil.getStateId(tile.getBlockState(Blocks.field_150347_e));
        this.voxelBlobRef = tile.getBlobStateReference();
        this.format = this.voxelBlobRef == null ? -1 : this.voxelBlobRef.getFormat();
    }

    public void fillWith(BlockState state) {
        this.voxelBlobRef = new VoxelBlobStateReference(ModUtil.getStateId(state), 0L);
        this.updateFromBlob();
    }

    public void setBlob(VoxelBlob vb) {
        this.voxelBlobRef = new VoxelBlobStateReference(vb, 0L);
        this.format = this.voxelBlobRef.getFormat();
        this.updateFromBlob();
    }

    public final void writeChisleData(CompoundNBT compound, boolean crossWorld) {
        VoxelBlobStateReference voxelRef = this.getRef();
        if (this.primaryBlockState == 0) {
            return;
        }
        int newFormat = crossWorld ? 2 : 3;
        byte[] voxelBytes = newFormat == this.format ? voxelRef.getByteArray() : voxelRef.getVoxelBlob().blobToBytes(newFormat);
        compound.func_74768_a(NBT_LIGHTVALUE, this.lightValue);
        if (crossWorld) {
            compound.func_74778_a(NBT_PRIMARY_STATE, StringStates.getNameFromStateID(this.primaryBlockState));
        } else {
            compound.func_74768_a(NBT_PRIMARY_STATE, this.primaryBlockState);
        }
        compound.func_74768_a(NBT_SIDE_FLAGS, this.sideState);
        compound.func_74757_a(NBT_NORMALCUBE_FLAG, this.isNormalCube);
        compound.func_74773_a(NBT_VERSIONED_VOXEL, voxelBytes);
    }

    public final boolean readChisleData(CompoundNBT compound, int preferedFormat) {
        byte[] vx;
        if (compound == null) {
            this.voxelBlobRef = new VoxelBlobStateReference(0, 0L);
            this.format = this.voxelBlobRef.getFormat();
            if (this.tile != null) {
                return this.tile.updateBlob(this, this.triggerUpdates);
            }
            return false;
        }
        this.sideState = compound.func_74762_e(NBT_SIDE_FLAGS);
        if (compound.func_74781_a(NBT_PRIMARY_STATE) instanceof StringNBT) {
            this.primaryBlockState = StringStates.getStateIDFromName(compound.func_74779_i(NBT_PRIMARY_STATE));
        }
        this.primaryBlockState = compound.func_74762_e(NBT_PRIMARY_STATE);
        this.lightValue = compound.func_74762_e(NBT_LIGHTVALUE);
        this.isNormalCube = compound.func_74767_n(NBT_NORMALCUBE_FLAG);
        byte[] v = compound.func_74770_j(NBT_VERSIONED_VOXEL);
        if (v.length == 0 && (vx = compound.func_74770_j(NBT_LEGACY_VOXEL)).length > 0) {
            VoxelBlob bx = new VoxelBlob();
            try {
                bx.fromLegacyByteArray(vx);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            v = bx.blobToBytes(3);
            this.format = 3;
        }
        if (this.primaryBlockState == 0) {
            this.primaryBlockState = ModUtil.getStateId(Blocks.field_150347_e.func_176223_P());
        }
        this.voxelBlobRef = new VoxelBlobStateReference(v, 0L);
        this.format = this.voxelBlobRef.getFormat();
        boolean formatChanged = false;
        if (preferedFormat != this.format && preferedFormat != -1) {
            formatChanged = true;
            v = this.voxelBlobRef.getVoxelBlob().blobToBytes(preferedFormat);
            this.voxelBlobRef = new VoxelBlobStateReference(v, 0L);
            this.format = this.voxelBlobRef.getFormat();
        }
        if (this.tile != null) {
            if (formatChanged) {
                this.tile.func_70296_d();
            }
            return this.tile.updateBlob(this, this.triggerUpdates);
        }
        return true;
    }

    public void updateFromBlob() {
        VoxelBlob vb = this.getRef().getVoxelBlob();
        VoxelStats common = vb.getVoxelStats();
        float floatLight = common.blockLight;
        this.isNormalCube = common.isNormalBlock;
        this.lightValue = Math.max(0, Math.min(15, (int)(floatLight * 15.0f)));
        this.sideState = vb.getSideFlags(5, 11, 16);
        this.primaryBlockState = common.mostCommonState;
    }

    public ItemStack getItemStack(boolean crossWorld) {
        BlockChiseled blk = ModBlocks.convertGivenStateToChiseledBlock(this.getPrimaryBlockState());
        if (blk != null) {
            ItemStack is = new ItemStack((IItemProvider)blk);
            CompoundNBT compound = ModUtil.getSubCompound(is, "BlockEntityTag", true);
            this.writeChisleData(compound, crossWorld);
            if (compound.func_186856_d() > 0) {
                return is;
            }
        }
        return null;
    }

    private VoxelBlobStateReference getRef() {
        if (this.voxelBlobRef == null) {
            this.voxelBlobRef = new VoxelBlobStateReference(0, 0L);
        }
        return this.voxelBlobRef;
    }

    public VoxelBlob getBlob() {
        return this.getRef().getVoxelBlob();
    }
}

