/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import javax.annotation.Nonnull;
import mod.chiselsandbits.api.BoxType;
import mod.chiselsandbits.api.IMultiStateBlock;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.data.VoxelShapeCache;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.utils.SingleBlockBlockReader;
import mod.chiselsandbits.utils.SingleBlockWorldReader;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.Nullable;

public class BlockChiseled
extends Block
implements ITileEntityProvider,
IMultiStateBlock {
    public static final BlockPos ZERO = BlockPos.field_177992_a;
    private static ThreadLocal<BlockState> actingAs = new ThreadLocal();
    public static final BooleanProperty FULL_BLOCK = BooleanProperty.func_177716_a((String)"full_block");
    public final String name;
    static ExceptionNoTileEntity noTileEntity = new ExceptionNoTileEntity();

    public BlockChiseled(String name, AbstractBlock.Properties properties) {
        super(properties);
        this.name = name;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FULL_BLOCK, (Comparable)Boolean.valueOf(false)));
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!willHarvest && ((Boolean)ChiselsAndBits.getConfig().getClient().addBrokenBlocksToCreativeClipboard.get()).booleanValue()) {
            try {
                TileEntityBlockChiseled tebc = BlockChiseled.getTileEntity((IBlockReader)world, pos);
                CreativeClipboardTab.addItem(tebc.getItemStack(player));
                UndoTracker.getInstance().add(world, pos, tebc.getBlobStateReference(), new VoxelBlobStateReference(0, 0L));
            }
            catch (ExceptionNoTileEntity e) {
                Log.noTileError(e);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return BlockChiseled.isFullCube(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return BlockChiseled.isFullCube(state) ? 0.2f : 1.0f;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        try {
            BlockPos target = useContext.func_195995_a();
            if (!(useContext instanceof DirectionalPlaceContext) && !useContext.func_196012_c()) {
                target = target.func_177972_a(useContext.func_196000_l().func_176734_d());
            }
            return BlockChiseled.getTileEntity((IBlockReader)useContext.func_195991_k(), target).getBlob().filled() == 0;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return super.func_196253_a(state, useContext);
        }
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        try {
            BlockState internalState = BlockChiseled.getTileEntity((IBlockReader)world, pos).getBlockState(Blocks.field_150348_b);
            if (internalState != null) {
                return internalState.func_177230_c().getSlipperiness(internalState, (IWorldReader)new SingleBlockWorldReader(internalState, internalState.func_177230_c(), world), BlockPos.field_177992_a, entity);
            }
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
        return super.getSlipperiness(state, world, pos, entity);
    }

    @Nonnull
    public static TileEntityBlockChiseled getTileEntity(TileEntity te) throws ExceptionNoTileEntity {
        if (te == null) {
            throw noTileEntity;
        }
        try {
            return (TileEntityBlockChiseled)te;
        }
        catch (ClassCastException e) {
            throw noTileEntity;
        }
    }

    @Nonnull
    public static TileEntityBlockChiseled getTileEntity(@Nonnull IBlockReader world, @Nonnull BlockPos pos) throws ExceptionNoTileEntity {
        TileEntity te = ModUtil.getTileEntitySafely(world, pos);
        return BlockChiseled.getTileEntity(te);
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return BlockChiseled.isFullCube(state) ? 0 : 1;
    }

    public static boolean isFullCube(BlockState state) {
        return (Boolean)state.func_177229_b((Property)FULL_BLOCK);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        try {
            BlockChiseled.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)BlockChiseled.getTileEntity(te).getItemStack(player));
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        try {
            if (stack == null || placer == null || !stack.func_77942_o()) {
                return;
            }
            TileEntityBlockChiseled bc = BlockChiseled.getTileEntity((IBlockReader)worldIn, pos);
            if (worldIn.field_72995_K) {
                bc.getState();
            }
            int rotations = ModUtil.getRotations(placer, ModUtil.getSide(stack));
            VoxelBlob blob = bc.getBlob();
            while (rotations-- > 0) {
                blob = blob.spin(Direction.Axis.Y);
            }
            bc.setBlob(blob);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (!(target instanceof BlockRayTraceResult)) {
            return ItemStack.field_190927_a;
        }
        try {
            return this.getPickBlock((BlockRayTraceResult)target, pos, BlockChiseled.getTileEntity(world, pos));
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return ModUtil.getEmptyStack();
        }
    }

    private ChiselToolType getClientHeldTool() {
        return ClientSide.instance.getHeldToolType(Hand.MAIN_HAND);
    }

    public ItemStack getPickBlock(BlockRayTraceResult target, BlockPos pos, TileEntityBlockChiseled te) {
        if (te.func_145831_w().field_72995_K) {
            if (this.getClientHeldTool() != null) {
                VoxelBlob vb = te.getBlob();
                BitLocation bitLoc = new BitLocation(target, BitOperation.CHISEL);
                int itemBlock = vb.get(bitLoc.bitX, bitLoc.bitY, bitLoc.bitZ);
                if (itemBlock == 0) {
                    return ModUtil.getEmptyStack();
                }
                return ItemChiseledBit.createStack(itemBlock, 1, false);
            }
            return te.getItemStack(ClientSide.instance.getPlayer());
        }
        return te.getItemStack(null);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FULL_BLOCK});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityBlockChiseled();
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        try {
            BlockState internalState = BlockChiseled.getTileEntity((IBlockReader)world, pos).getBlockState(this);
            return ClientSide.instance.addBlockDestroyEffects(world, pos, internalState, manager);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        if (!(target instanceof BlockRayTraceResult)) {
            return false;
        }
        try {
            BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)target;
            BlockPos pos = rayTraceResult.func_216350_a();
            BlockState bs = BlockChiseled.getTileEntity((IBlockReader)world, pos).getBlockState(this);
            return ClientSide.instance.addHitEffects(world, rayTraceResult, bs, effectRenderer);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return true;
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        try {
            VoxelBlob blob = BlockChiseled.getTileEntity(reader, pos).getBlob();
            if (blob == null) {
                return VoxelShapes.func_197880_a();
            }
            return VoxelShapeCache.getInstance().get(blob, BoxType.OCCLUSION);
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            return VoxelShapes.func_197880_a();
        }
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        try {
            VoxelBlob blob = BlockChiseled.getTileEntity(worldIn, pos).getBlob();
            if (blob == null) {
                return VoxelShapes.func_197880_a();
            }
            return VoxelShapeCache.getInstance().get(blob, BoxType.COLLISION);
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            return VoxelShapes.func_197880_a();
        }
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        try {
            VoxelBlob blob = BlockChiseled.getTileEntity(reader, pos).getBlob();
            if (blob == null) {
                return VoxelShapes.func_197880_a();
            }
            return VoxelShapeCache.getInstance().get(blob, BoxType.OCCLUSION);
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            return VoxelShapes.func_197880_a();
        }
    }

    public boolean func_208619_r() {
        return true;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public static boolean replaceWithChiseled(World world, BlockPos pos, BlockState originalState, boolean triggerUpdate) {
        return BlockChiseled.replaceWithChiseled((World)world, (BlockPos)pos, (BlockState)originalState, (int)0, (boolean)triggerUpdate).success;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        try {
            BlockChiseled.getTileEntity((IBlockReader)world, pos).rotateBlock();
            return state;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return state;
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityBlockChiseled();
    }

    public static ReplaceWithChiseledValue replaceWithChiseled(@Nonnull World world, @Nonnull BlockPos pos, BlockState originalState, int fragmentBlockStateID, boolean triggerUpdate) {
        BlockState actingState = originalState;
        Block target = originalState.func_177230_c();
        boolean isAir = world.func_175623_d(pos) || actingState.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
        ReplaceWithChiseledValue rv = new ReplaceWithChiseledValue();
        if (BlockBitInfo.canChisel(actingState) || isAir) {
            BlockChiseled blk = ModBlocks.convertGivenStateToChiseledBlock(originalState);
            int BlockID = ModUtil.getStateId(actingState);
            if (isAir) {
                actingState = ModUtil.getStateById(fragmentBlockStateID);
                target = actingState.func_177230_c();
                BlockID = ModUtil.getStateId(actingState);
                blk = ModBlocks.convertGivenStateToChiseledBlock(actingState);
                actingState = Blocks.field_150350_a.func_176223_P();
            }
            if (BlockID == 0) {
                return rv;
            }
            if (blk != null && blk != target) {
                TileEntityBlockChiseled tec;
                TileEntityBlockChiseled.setLightFromBlock(actingState);
                world.func_180501_a(pos, blk.func_176223_P(), triggerUpdate ? 3 : 0);
                TileEntityBlockChiseled.setLightFromBlock(null);
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof TileEntityBlockChiseled)) {
                    tec = (TileEntityBlockChiseled)blk.createTileEntity(blk.func_176223_P(), (IBlockReader)world);
                    world.func_175690_a(pos, (TileEntity)tec);
                } else {
                    tec = (TileEntityBlockChiseled)te;
                }
                if (tec != null) {
                    tec.fillWith(actingState);
                    tec.setPrimaryBlockStateId(BlockID);
                    tec.setState(tec.getState(), tec.getBlobStateReference());
                }
                rv.success = true;
                rv.te = tec;
                return rv;
            }
        }
        return rv;
    }

    public BlockState getCommonState(TileEntityBlockChiseled te) {
        VoxelBlob vb;
        VoxelBlobStateReference data = te.getBlobStateReference();
        if (data != null && (vb = data.getVoxelBlob()) != null) {
            return ModUtil.getStateById(vb.getVoxelStats().mostCommonState);
        }
        return null;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState realState = world.func_180495_p(pos);
        Block realBlock = realState.func_177230_c();
        if (realBlock != this) {
            return realBlock.getLightValue(realState, world, pos);
        }
        if (((Boolean)ChiselsAndBits.getConfig().getServer().enableBitLightSource.get()).booleanValue()) {
            try {
                return BlockChiseled.getTileEntity(world, pos).getLightValue();
            }
            catch (ExceptionNoTileEntity e) {
                Log.noTileError(e);
            }
        }
        return 0;
    }

    public static void setActingAs(BlockState state) {
        actingAs.set(state);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (((Boolean)ChiselsAndBits.getConfig().getServer().enableToolHarvestLevels.get()).booleanValue()) {
            BlockState activeState = actingAs.get();
            if (activeState == null) {
                activeState = this.getPrimaryState(world, pos);
            }
            return activeState.canHarvestBlock((IBlockReader)new SingleBlockBlockReader(activeState), pos, player);
        }
        return true;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)ChiselsAndBits.getConfig().getServer().enableToolHarvestLevels.get()).booleanValue()) {
            float hardness;
            BlockState actingState = actingAs.get();
            if (actingState == null) {
                actingState = this.getPrimaryState(worldIn, pos);
            }
            if ((hardness = state.func_185887_b(worldIn, pos)) < 0.0f) {
                return 0.0f;
            }
            float denom = player.field_71071_by.func_184438_a(actingState);
            float numer = player.field_71071_by.func_184438_a(state);
            if (!state.canHarvestBlock((IBlockReader)new SingleBlockBlockReader(state), ZERO, player)) {
                return player.getDigSpeed(actingState, pos) / hardness / 100.0f * (numer / denom);
            }
            return player.getDigSpeed(actingState, pos) / hardness / 30.0f * (numer / denom);
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return Blocks.field_150348_b.isToolEffective(Blocks.field_150348_b.func_176223_P(), tool);
    }

    public ResourceLocation getModel() {
        return new ResourceLocation("chiselsandbits", this.name);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @Override
    public BlockState getPrimaryState(IBlockReader world, BlockPos pos) {
        try {
            return BlockChiseled.getTileEntity(world, pos).getBlockState(Blocks.field_150348_b);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return Blocks.field_150348_b.func_176223_P();
        }
    }

    public boolean basicHarvestBlockTest(World world, BlockPos pos, PlayerEntity player) {
        return super.canHarvestBlock(world.func_180495_p(pos), (IBlockReader)world, pos, player);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public static class ReplaceWithChiseledValue {
        public boolean success = false;
        public TileEntityBlockChiseled te = null;
    }
}

