/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.HashMap;
import mod.chiselsandbits.api.IgnoreBlockLogic;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.ReflectionHelperBlock;
import mod.chiselsandbits.chiseledblock.data.VoxelType;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModTags;
import mod.chiselsandbits.render.helpers.ModelUtil;
import mod.chiselsandbits.utils.SingleBlockBlockReader;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlimeBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockBitInfo {
    private static HashMap<Block, Boolean> ignoreLogicBlocks = new HashMap();
    private static HashMap<BlockState, BlockBitInfo> stateBitInfo;
    private static HashMap<Block, SupportsAnalysisResult> supportedBlocks;
    private static HashMap<Block, Boolean> forcedBlocks;
    private static HashMap<Block, Fluid> fluidBlocks;
    private static IntObjectMap<Fluid> fluidStates;
    private static HashMap<BlockState, Integer> bitColor;
    public final boolean isCompatible;
    public final float hardness;
    public final float explosionResistance;

    public static int getColorFor(BlockState state, int tint) {
        Integer out = bitColor.get(state);
        if (out == null) {
            ItemStack target;
            Block blk = state.func_177230_c();
            Fluid fluid = BlockBitInfo.getFluidFromBlock(blk);
            out = fluid != null ? Integer.valueOf(fluid.getAttributes().getColor()) : (ModUtil.isEmpty(target = ModUtil.getItemStackFromBlockState(state)) ? Integer.valueOf(0xFFFFFF) : ModelUtil.getItemStackColor(target, tint));
            bitColor.put(state, out);
        }
        return out;
    }

    public static void recalculate() {
        BlockBitInfo.recalculateFluids();
    }

    public static void recalculateFluids() {
        fluidBlocks.clear();
        for (Fluid o : ForgeRegistries.FLUIDS) {
            if (!o.func_207188_f().func_206889_d()) continue;
            BlockBitInfo.addFluidBlock(o);
        }
    }

    public static void addFluidBlock(Fluid fluid) {
        fluidBlocks.put(fluid.func_207188_f().func_206883_i().func_177230_c(), fluid);
        for (BlockState state : fluid.func_207188_f().func_206883_i().func_177230_c().func_176194_O().func_177619_a()) {
            try {
                fluidStates.put(ModUtil.getStateId(state), (Object)fluid);
            }
            catch (Throwable t) {
                Log.logError("Error while determining fluid state.", t);
            }
        }
        stateBitInfo.clear();
        supportedBlocks.clear();
    }

    public static Fluid getFluidFromBlock(Block blk) {
        return fluidBlocks.get(blk);
    }

    public static VoxelType getTypeFromStateID(int bit) {
        if (bit == 0) {
            return VoxelType.AIR;
        }
        return fluidStates.containsKey(bit) ? VoxelType.FLUID : VoxelType.SOLID;
    }

    public static void ignoreBlockLogic(Block which) {
        ignoreLogicBlocks.put(which, true);
        BlockBitInfo.reset();
    }

    public static void forceStateCompatibility(Block which, boolean forceStatus) {
        forcedBlocks.put(which, forceStatus);
        BlockBitInfo.reset();
    }

    public static void reset() {
        stateBitInfo.clear();
        supportedBlocks.clear();
    }

    public static BlockBitInfo getBlockInfo(BlockState state) {
        BlockBitInfo bit = stateBitInfo.get(state);
        if (bit == null) {
            bit = BlockBitInfo.createFromState(state);
            stateBitInfo.put(state, bit);
        }
        return bit;
    }

    public static SupportsAnalysisResult doSupportAnalysis(BlockState state) {
        if (state.func_177230_c() instanceof BlockChiseled) {
            return new SupportsAnalysisResult(true, LocalStrings.ChiselSupportGenericNotSupported, LocalStrings.ChiselSupportIsAlreadyChiseled);
        }
        if (forcedBlocks.containsKey(state.func_177230_c())) {
            boolean forcing = forcedBlocks.get(state.func_177230_c());
            return new SupportsAnalysisResult(forcing, LocalStrings.ChiselSupportForcedUnsupported, LocalStrings.ChiselSupportForcedSupported);
        }
        Block blk = state.func_177230_c();
        if (supportedBlocks.containsKey(blk)) {
            return supportedBlocks.get(blk);
        }
        if (blk.func_203417_a(ModTags.Blocks.BLOCKED_CHISELABLE)) {
            SupportsAnalysisResult result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportTagBlackListed, LocalStrings.ChiselSupportTagWhitelisted);
            supportedBlocks.put(blk, result);
            return result;
        }
        if (blk.func_203417_a(ModTags.Blocks.FORCED_CHISELABLE)) {
            SupportsAnalysisResult result = new SupportsAnalysisResult(true, LocalStrings.ChiselSupportTagBlackListed, LocalStrings.ChiselSupportTagWhitelisted);
            supportedBlocks.put(blk, result);
            BlockBitInfo info = BlockBitInfo.createFromState(state);
            stateBitInfo.put(state, info);
            return result;
        }
        try {
            ReflectionHelperBlock pb = new ReflectionHelperBlock();
            Class<?> blkClass = blk.getClass();
            pb.func_220076_a(state, null);
            Class<?> wc = BlockBitInfo.getDeclaringClass(blkClass, pb.MethodName, BlockState.class, LootContext.Builder.class);
            boolean quantityDroppedTest = wc == Block.class || wc == AbstractBlock.class;
            boolean isNotSlab = Item.func_150898_a((Block)blk) != Items.field_190931_a;
            boolean itemExistsOrNotSpecialDrops = quantityDroppedTest || isNotSlab;
            pb.func_220053_a(null, null, null, null);
            Class<?> collisionClass = BlockBitInfo.getDeclaringClass(blkClass, pb.MethodName, BlockState.class, IBlockReader.class, BlockPos.class, ISelectionContext.class);
            boolean noCustomCollision = collisionClass == Block.class || collisionClass == AbstractBlock.class || blk.getClass() == SlimeBlock.class;
            boolean isFullBlock = state.func_200132_m() || blk instanceof AbstractGlassBlock;
            BlockBitInfo info = BlockBitInfo.createFromState(state);
            boolean tickingBehavior = blk.func_149653_t(state) && (Boolean)ChiselsAndBits.getConfig().getServer().blackListRandomTickingBlocks.get() != false;
            boolean hasBehavior = blk.hasTileEntity(state) || tickingBehavior;
            boolean supportedMaterial = ModBlocks.convertGivenStateToChiseledBlock(state) != null;
            Boolean IgnoredLogic = ignoreLogicBlocks.get(blk);
            if (blkClass.isAnnotationPresent(IgnoreBlockLogic.class) || IgnoredLogic != null && IgnoredLogic.booleanValue()) {
                isFullBlock = true;
                noCustomCollision = true;
                hasBehavior = false;
                itemExistsOrNotSpecialDrops = true;
            }
            if (info.isCompatible && noCustomCollision && info.hardness >= -0.01f && isFullBlock && supportedMaterial && !hasBehavior && itemExistsOrNotSpecialDrops) {
                SupportsAnalysisResult result = new SupportsAnalysisResult(true, LocalStrings.ChiselSupportGenericNotSupported, blkClass.isAnnotationPresent(IgnoreBlockLogic.class) || IgnoredLogic != null && IgnoredLogic != false ? LocalStrings.ChiselSupportLogicIgnored : LocalStrings.ChiselSupportGenericSupported);
                supportedBlocks.put(blk, result);
                stateBitInfo.put(state, info);
                return result;
            }
            if (fluidBlocks.containsKey(blk)) {
                stateBitInfo.put(state, info);
                SupportsAnalysisResult result = new SupportsAnalysisResult(true, LocalStrings.ChiselSupportGenericNotSupported, LocalStrings.ChiselSupportGenericFluidSupport);
                supportedBlocks.put(blk, result);
                return result;
            }
            SupportsAnalysisResult result = null;
            if (!info.isCompatible) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportCompatDeactivated, LocalStrings.ChiselSupportGenericSupported);
            } else if (!noCustomCollision) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportCustomCollision, LocalStrings.ChiselSupportGenericSupported);
            } else if (info.hardness < -0.01f) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportNoHardness, LocalStrings.ChiselSupportGenericSupported);
            } else if (!isNotSlab) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportIsSlab, LocalStrings.ChiselSupportGenericSupported);
            } else if (!isFullBlock) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportNotFullBlock, LocalStrings.ChiselSupportGenericSupported);
            } else if (hasBehavior) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportHasBehaviour, LocalStrings.ChiselSupportGenericSupported);
            } else if (!quantityDroppedTest) {
                result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportHasCustomDrops, LocalStrings.ChiselSupportGenericSupported);
            }
            supportedBlocks.put(blk, result);
            return result;
        }
        catch (Throwable t) {
            SupportsAnalysisResult result = new SupportsAnalysisResult(false, LocalStrings.ChiselSupportFailureToAnalyze, LocalStrings.ChiselSupportGenericSupported);
            supportedBlocks.put(blk, result);
            return result;
        }
    }

    public static boolean isSupported(BlockState state) {
        return BlockBitInfo.doSupportAnalysis(state).isSupported();
    }

    private static Class<?> getDeclaringClass(Class<?> blkClass, String methodName, Class<?> ... args) {
        try {
            return blkClass.getMethod(methodName, args).getDeclaringClass();
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError e) {
            Log.eligibility("Unable to determine blocks eligibility for chiseling, " + blkClass.getName() + " attempted to load " + e.getMessage() + " missing @OnlyIn( Dist.CLIENT ) or @Optional?");
            return blkClass;
        }
        catch (Throwable t) {
            return blkClass;
        }
        return BlockBitInfo.getDeclaringClass(blkClass.getSuperclass(), methodName, args);
    }

    private BlockBitInfo(boolean isCompatible, float hardness, float explosionResistance) {
        this.isCompatible = isCompatible;
        this.hardness = hardness;
        this.explosionResistance = explosionResistance;
    }

    public static BlockBitInfo createFromState(BlockState state) {
        try {
            ReflectionHelperBlock reflectBlock = new ReflectionHelperBlock();
            Block blk = state.func_177230_c();
            Class<?> blkClass = blk.getClass();
            reflectBlock.func_180647_a(null, null, null, null);
            Class<?> b_Class = BlockBitInfo.getDeclaringClass(blkClass, reflectBlock.MethodName, BlockState.class, PlayerEntity.class, IBlockReader.class, BlockPos.class);
            boolean test_b = b_Class == Block.class || b_Class == AbstractBlock.class;
            reflectBlock.func_149638_a();
            Class<?> exploResistanceClz = BlockBitInfo.getDeclaringClass(blkClass, reflectBlock.MethodName, new Class[0]);
            boolean test_c = exploResistanceClz == Block.class || exploResistanceClz == AbstractBlock.class;
            reflectBlock.getExplosionResistance(null, null, null, null);
            exploResistanceClz = BlockBitInfo.getDeclaringClass(blkClass, reflectBlock.MethodName, BlockState.class, IBlockReader.class, BlockPos.class, Explosion.class);
            boolean test_d = exploResistanceClz == Block.class || exploResistanceClz == AbstractBlock.class || exploResistanceClz == null || exploResistanceClz == IForgeBlock.class;
            boolean isFluid = fluidStates.containsKey(ModUtil.getStateId(state));
            if (test_b && test_c && test_d && !isFluid) {
                float blockHardness = state.func_185887_b((IBlockReader)new SingleBlockBlockReader(state, state.func_177230_c()), BlockPos.field_177992_a);
                float resistance = blk.getExplosionResistance(state, (IBlockReader)new SingleBlockBlockReader(state, state.func_177230_c()), BlockPos.field_177992_a, new Explosion(null, null, null, null, 0.0, 1.0, 0.0, 10.0f, false, Explosion.Mode.NONE));
                return new BlockBitInfo(true, blockHardness, resistance);
            }
            Block stone = Blocks.field_150348_b;
            return new BlockBitInfo((Boolean)ChiselsAndBits.getConfig().getServer().compatabilityMode.get(), 2.0f, 6.0f);
        }
        catch (Exception err) {
            return new BlockBitInfo(false, -1.0f, -1.0f);
        }
    }

    public static boolean canChisel(BlockState state) {
        return state.func_177230_c() instanceof BlockChiseled || BlockBitInfo.isSupported(state);
    }

    public static boolean canChisel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockChiseled) {
            return true;
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)stack.func_77973_b();
            Block block = blockItem.func_179223_d();
            BlockState blockState = block.func_176223_P();
            SupportsAnalysisResult result = BlockBitInfo.doSupportAnalysis(blockState);
            return result.supported;
        }
        return false;
    }

    public static boolean isChiseled(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemBlockChiseled;
    }

    static {
        ignoreLogicBlocks.put(Blocks.field_196572_aa, true);
        ignoreLogicBlocks.put(Blocks.field_196647_Y, true);
        ignoreLogicBlocks.put(Blocks.field_196574_ab, true);
        ignoreLogicBlocks.put(Blocks.field_196648_Z, true);
        ignoreLogicBlocks.put(Blocks.field_196642_W, true);
        ignoreLogicBlocks.put(Blocks.field_196645_X, true);
        ignoreLogicBlocks.put(Blocks.field_150433_aE, true);
        stateBitInfo = new HashMap();
        supportedBlocks = new HashMap();
        forcedBlocks = new HashMap();
        fluidBlocks = new HashMap();
        fluidStates = new IntObjectHashMap();
        bitColor = new HashMap();
    }

    public static class SupportsAnalysisResult {
        private final boolean supported;
        private final LocalStrings unsupportedReason;
        private final LocalStrings supportedReason;

        public SupportsAnalysisResult(boolean supported, LocalStrings unsupportedReason, LocalStrings supportedReason) {
            this.supported = supported;
            this.unsupportedReason = unsupportedReason;
            this.supportedReason = supportedReason;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public LocalStrings getUnsupportedReason() {
            return this.unsupportedReason;
        }

        public LocalStrings getSupportedReason() {
            return this.supportedReason;
        }
    }
}

