/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitstorage;

import java.util.Objects;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.registry.ModTileEntityTypes;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TileEntityBitStorage
extends TileEntity
implements IItemHandler,
IFluidHandler {
    public LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this);
    public LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this);
    public static final int MAX_CONTENTS = 4096;
    public static final int MB_PER_BIT_CONVERSION = 125;
    public static final int BITS_PER_MB_CONVERSION = 512;
    private BlockState state = null;
    private Fluid myFluid = null;
    private int bits = 0;
    private int oldLV = -1;

    public TileEntityBitStorage() {
        super((TileEntityType)ModTileEntityTypes.BIT_STORAGE.get());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        return this.func_189515_b(nbttagcompound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT t = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(t));
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        String fluid = nbt.func_74779_i("fluid");
        if (fluid.equals("")) {
            int rawState = nbt.func_74762_e("blockstate");
            this.state = rawState != -1 ? ModUtil.getStateById(rawState) : null;
        } else {
            this.myFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid));
        }
        this.bits = nbt.func_74762_e("bits");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74778_a("fluid", this.myFluid == null ? "" : Objects.requireNonNull(this.myFluid.getRegistryName()).toString());
        nbt.func_74768_a("blockstate", this.myFluid != null || this.state == null ? -1 : ModUtil.getStateId(this.state));
        nbt.func_74768_a("bits", this.bits);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.bits > 0 && slot == 0 && (this.myFluid != null || this.state != null)) {
            if (this.myFluid != null) {
                return this.getFluidBitStack(this.myFluid, this.bits);
            }
            return this.getBlockBitStack(this.state, this.bits);
        }
        return ModUtil.getEmptyStack();
    }

    @Nonnull
    public ItemStack getFluidBitStack(Fluid liquid, int amount) {
        if (liquid == null) {
            return ModUtil.getEmptyStack();
        }
        return ItemChiseledBit.createStack(ModUtil.getStateId(liquid.func_207188_f().func_206883_i()), amount, false);
    }

    @Nonnull
    public ItemStack getBlockBitStack(BlockState blockState, int amount) {
        if (blockState == null || blockState.getBlockState() == null) {
            return ModUtil.getEmptyStack();
        }
        return ItemChiseledBit.createStack(ModUtil.getStateId(blockState), amount, false);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        BlockState stackState;
        if (!ModUtil.isEmpty(stack) && stack.func_77973_b() instanceof ItemChiseledBit) {
            int state = ItemChiseledBit.getStackState(stack);
            BlockState blk = ModUtil.getStateById(state);
            ItemStack fluidInsertion = this.attemptFluidBitStackInsertion(stack, simulate, blk);
            if (fluidInsertion != stack) {
                return fluidInsertion;
            }
            return this.attemptSolidBitStackInsertion(stack, simulate, blk);
        }
        if (!ModUtil.isEmpty(stack) && BlockBitInfo.canChisel(stack) && this.myFluid == null && (stackState = ModUtil.getStateFromItem(stack)).func_177230_c() != Blocks.field_150350_a) {
            if (this.state == null) {
                this.state = stackState;
                this.bits = 4096;
            } else if (ModUtil.getStateId(this.state) == ModUtil.getStateId(stackState)) {
                // empty if block
            }
        }
        return stack;
    }

    @NotNull
    private ItemStack attemptFluidBitStackInsertion(ItemStack stack, boolean simulate, BlockState blk) {
        boolean canInsert;
        Fluid f = null;
        for (Fluid fl : ForgeRegistries.FLUIDS) {
            if (fl.func_207188_f().func_206883_i().func_177230_c() != blk.func_177230_c()) continue;
            f = fl;
            break;
        }
        if (f == null) {
            return stack;
        }
        ItemStack bitItem = this.getFluidBitStack(this.myFluid, this.bits);
        boolean bl = canInsert = ModUtil.isEmpty(bitItem) || ItemStack.func_77970_a((ItemStack)bitItem, (ItemStack)stack) && bitItem.func_77973_b() == stack.func_77973_b() || this.state == null;
        if (canInsert) {
            int merged = this.bits + ModUtil.getStackSize(stack);
            int amount = Math.min(merged, 4096);
            if (!simulate) {
                Fluid oldFluid = this.myFluid;
                BlockState oldState = this.state;
                int oldBits = this.bits;
                this.myFluid = f;
                this.state = null;
                this.bits = amount;
                if (this.bits != oldBits || this.myFluid != oldFluid || oldState != null) {
                    this.saveAndUpdate();
                }
            }
            if (amount < merged) {
                ItemStack out = ModUtil.copy(stack);
                ModUtil.setStackSize(out, merged - amount);
                return out;
            }
            return ModUtil.getEmptyStack();
        }
        return stack;
    }

    @NotNull
    private ItemStack attemptSolidBitStackInsertion(ItemStack stack, boolean simulate, BlockState blk) {
        boolean canInsert;
        Fluid f = null;
        for (Fluid fl : ForgeRegistries.FLUIDS) {
            if (fl.func_207188_f().func_206883_i().func_177230_c() != blk.func_177230_c()) continue;
            f = fl;
            break;
        }
        if (f != null) {
            return stack;
        }
        ItemStack bitItem = this.getBlockBitStack(blk, this.bits);
        boolean bl = canInsert = ModUtil.isEmpty(bitItem) || ItemStack.func_77970_a((ItemStack)bitItem, (ItemStack)stack) && bitItem.func_77973_b() == stack.func_77973_b();
        if (canInsert) {
            int merged = this.bits + ModUtil.getStackSize(stack);
            int amount = Math.min(merged, 4096);
            if (!simulate) {
                Fluid oldFluid = this.myFluid;
                BlockState oldBlockState = this.state;
                int oldBits = this.bits;
                this.myFluid = null;
                this.state = blk;
                this.bits = amount;
                if (this.bits != oldBits || this.state != oldBlockState || oldFluid != null) {
                    this.saveAndUpdate();
                }
            }
            if (amount < merged) {
                ItemStack out = ModUtil.copy(stack);
                ModUtil.setStackSize(out, merged - amount);
                return out;
            }
            return ModUtil.getEmptyStack();
        }
        return stack;
    }

    private void saveAndUpdate() {
        if (this.field_145850_b == null || this.func_145831_w() == null) {
            return;
        }
        this.func_70296_d();
        ModUtil.sendUpdate(this.field_145850_b, this.func_174877_v());
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.func_145831_w().func_225524_e_().func_215568_a(this.func_174877_v());
            this.oldLV = lv;
        }
    }

    @Nonnull
    public ItemStack extractBits(int slot, int amount, boolean simulate) {
        ItemStack contents = this.getStackInSlot(slot);
        if (!contents.func_190926_b() && amount > 0) {
            ModUtil.setStackSize(contents, Math.min(amount, ModUtil.getStackSize(contents)));
            if (!simulate) {
                int oldBits = this.bits;
                this.bits -= ModUtil.getStackSize(contents);
                if (this.bits <= 0) {
                    this.bits = 0;
                    this.state = null;
                    this.myFluid = null;
                }
                if (this.bits != oldBits) {
                    this.saveAndUpdate();
                }
            }
            return contents;
        }
        return ModUtil.getEmptyStack();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractBits(slot, Math.min(amount, ((ItemChiseledBit)ModItems.ITEM_BLOCK_BIT.get()).getItemStackLimit(ItemStack.field_190927_a)), simulate);
    }

    public FluidStack getAccessableFluid() {
        if (this.myFluid == null && this.state != null) {
            return FluidStack.EMPTY;
        }
        int mb = (this.bits - this.bits % 512) / 512;
        if ((mb *= 125) > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, mb);
        }
        return FluidStack.EMPTY;
    }

    FluidStack getBitsAsFluidStack() {
        if (this.myFluid == null && this.state != null) {
            return FluidStack.EMPTY;
        }
        if (this.bits > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, this.bits);
        }
        return null;
    }

    public int getLightValue() {
        BlockState workingState;
        BlockState blockState = workingState = this.myFluid == null ? this.state : this.myFluid.func_207188_f().func_206883_i();
        if (workingState == null) {
            return 0;
        }
        return DeprecationHelper.getLightValue(workingState);
    }

    boolean extractBits(PlayerEntity playerIn, double hitX, double hitY, double hitZ, BlockPos pos) {
        if (!playerIn.func_225608_bj_()) {
            ItemStack is = this.extractItem(0, 64, false);
            if (!is.func_190926_b()) {
                ChiselsAndBits.getApi().giveBitToPlayer(playerIn, is, new Vector3d(hitX + (double)pos.func_177958_n(), hitY + (double)pos.func_177956_o(), hitZ + (double)pos.func_177952_p()));
            }
            return true;
        }
        return false;
    }

    boolean addAllPossibleBits(PlayerEntity playerIn) {
        if (playerIn.func_225608_bj_()) {
            boolean change = false;
            for (int x = 0; x < playerIn.field_71071_by.func_70302_i_(); ++x) {
                IBitBag bag;
                ItemStack stackInSlot = ModUtil.nonNull(playerIn.field_71071_by.func_70301_a(x));
                if (ChiselsAndBits.getApi().getItemType(stackInSlot) == ItemType.CHISLED_BIT) {
                    playerIn.field_71071_by.func_70299_a(x, this.insertItem(0, stackInSlot, false));
                    change = true;
                }
                if (ChiselsAndBits.getApi().getItemType(stackInSlot) != ItemType.BIT_BAG || (bag = ChiselsAndBits.getApi().getBitbag(stackInSlot)) == null) continue;
                for (int y = 0; y < bag.getSlots(); ++y) {
                    bag.insertItem(y, this.insertItem(0, bag.extractItem(y, bag.getSlotLimit(y), false), false), false);
                    change = true;
                }
            }
            if (change) {
                playerIn.field_71071_by.func_70296_d();
            }
            return change;
        }
        return false;
    }

    boolean addHeldBits(@Nonnull ItemStack current, PlayerEntity playerIn) {
        if ((playerIn.func_225608_bj_() || this.bits == 0) && (ChiselsAndBits.getApi().getItemType(current) == ItemType.CHISLED_BIT || BlockBitInfo.canChisel(current))) {
            ItemStack resultStack = this.insertItem(0, current, false);
            if (!playerIn.func_184812_l_()) {
                playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, resultStack);
                playerIn.field_71071_by.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getAccessableFluid();
    }

    public int getTankCapacity(int tank) {
        return 4096;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (this.getAccessableFluid().isEmpty() && this.state == null) {
            return true;
        }
        if (this.state != null) {
            return false;
        }
        return Objects.equals(this.getAccessableFluid().getFluid().getRegistryName(), stack.getFluid().getRegistryName());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || this.state != null) {
            return 0;
        }
        int possibleAmount = resource.getAmount() - resource.getAmount() % 125;
        if (possibleAmount > 0) {
            int bitCount = possibleAmount * 512 / 125;
            ItemStack bitItems = this.getFluidBitStack(resource.getFluid(), bitCount);
            ItemStack leftOver = this.insertItem(0, bitItems, action.simulate());
            if (ModUtil.isEmpty(leftOver)) {
                return possibleAmount;
            }
            int mbUsedUp = ModUtil.getStackSize(leftOver);
            mbUsedUp *= 125;
            mbUsedUp += 511;
            return resource.getAmount() - (mbUsedUp /= 512);
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || this.state != null) {
            return FluidStack.EMPTY;
        }
        FluidStack a = this.getAccessableFluid();
        if (a != null && resource.containsFluid(a)) {
            int aboutHowMuch = resource.getAmount();
            int mbThatCanBeRemoved = Math.min(a.getAmount(), aboutHowMuch - aboutHowMuch % 125);
            if (mbThatCanBeRemoved > 0) {
                a.setAmount(mbThatCanBeRemoved);
                if (action.execute()) {
                    int bitCount = mbThatCanBeRemoved * 512 / 125;
                    this.extractBits(0, bitCount, false);
                }
                return a;
            }
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.state != null) {
            return FluidStack.EMPTY;
        }
        FluidStack a = this.getAccessableFluid();
        if (a != null) {
            int aboutHowMuch = maxDrain;
            int mbThatCanBeRemoved = Math.min(a.getAmount(), aboutHowMuch - aboutHowMuch % 125);
            if (mbThatCanBeRemoved > 0) {
                a.setAmount(mbThatCanBeRemoved);
                if (action.execute()) {
                    int bitCount = mbThatCanBeRemoved * 512 / 125;
                    this.extractBits(0, bitCount, false);
                }
                return a;
            }
        }
        return FluidStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return 512;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return !ModUtil.isEmpty(stack) && (stack.func_77973_b() instanceof ItemChiseledBit || BlockBitInfo.canChisel(stack));
    }

    public BlockState getState() {
        return this.state;
    }

    public Fluid getMyFluid() {
        return this.myFluid;
    }

    public int getBits() {
        return this.bits;
    }
}

