/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.ChunkLoaderSBRH;
import codechicken.chunkloader.ChunkLoaderSPH;
import codechicken.chunkloader.TileChunkLoader;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.chunkloader.TileSpotLoader;
import codechicken.core.ServerUtils;
import codechicken.lib.packet.PacketCustom;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockChunkLoader
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    IIcon[][] icons;

    public BlockChunkLoader() {
        super(Material.field_151576_e);
        this.func_149711_c(20.0f);
        this.func_149752_b(100.0f);
        this.func_149672_a(field_149769_e);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.setBlockBoundsForItemRender(world.func_72805_g(x, y, z));
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (world.func_72805_g(x, y, z) == 1) {
            return false;
        }
        return side == ForgeDirection.DOWN;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void setBlockBoundsForItemRender(int metadata) {
        switch (metadata) {
            case 0: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.4375f, 0.75f);
            }
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta][side > 2 ? 2 : side];
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != 0 || player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            TileChunkLoader tile = (TileChunkLoader)world.func_147438_o(x, y, z);
            if (tile.owner == null || tile.owner.equals(player.func_70005_c_()) || ChunkLoaderManager.opInteract() && ServerUtils.isPlayerOP((String)player.func_70005_c_())) {
                PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 12);
                packet.writeCoord(x, y, z);
                packet.sendToPlayer(player);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chickenchunks.accessdenied", new Object[0]));
            }
        }
        return true;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack itemstack) {
        if (world.field_72995_K) {
            return;
        }
        TileChunkLoaderBase ctile = (TileChunkLoaderBase)world.func_147438_o(i, j, k);
        ctile.onBlockPlacedBy(entityliving);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == 0) {
            return new TileChunkLoader();
        }
        if (meta == 1) {
            return new TileSpotLoader();
        }
        return null;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[2][3];
        for (int m = 0; m < this.icons.length; ++m) {
            for (int i = 0; i < this.icons[m].length; ++i) {
                this.icons[m][i] = par1IconRegister.func_94245_a("chickenchunks:block_" + m + "_" + i);
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ChunkLoaderSBRH.renderID;
    }
}

