/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.data.AbstractMultiBlock;
import com.carpentersblocks.data.ISided;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GarageDoor
extends AbstractMultiBlock
implements ISided {
    public static final GarageDoor INSTANCE = new GarageDoor();
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_GLASS_TOP = 1;
    public static final int TYPE_GLASS = 2;
    public static final int TYPE_SIDING = 3;
    public static final int TYPE_HIDDEN = 4;
    public static final int STATE_CLOSED = 0;
    public static final int STATE_OPEN = 1;
    public static final byte DOOR_NONRIGID = 0;
    public static final byte DOOR_RIGID = 1;

    public int getType(TEBase TE) {
        return TE.getData() & 0xF;
    }

    public void setType(TEBase TE, int type) {
        int temp = TE.getData() & 0xFFFFFFF0 | type;
        TE.setData(temp);
    }

    @Override
    public ForgeDirection getDirection(TEBase TE) {
        int side = (TE.getData() & 0x70) >> 4;
        return ForgeDirection.getOrientation((int)side);
    }

    @Override
    public boolean setDirection(TEBase TE, ForgeDirection dir) {
        int temp = TE.getData() & 0xFFFFFF8F | dir.ordinal() << 4;
        return TE.setData(temp);
    }

    public int getState(TEBase TE) {
        return (TE.getData() & 0x80) >> 7;
    }

    public void setState(TEBase TE, int state) {
        int temp = TE.getData() & 0xFFFFFF7F | state << 7;
        TE.setData(temp);
    }

    public boolean isRigid(TEBase TE) {
        return this.getRigidity(TE) == 1;
    }

    public int getRigidity(TEBase TE) {
        return (TE.getData() & 0x100) >> 8;
    }

    public void setRigidity(TEBase TE, int rigidity) {
        int temp = TE.getData() & 0xFFFFFEFF | rigidity << 8;
        TE.setData(temp);
    }

    public void setHost(TEBase TE) {
        int temp = TE.getData() | 0x200;
        TE.setData(temp);
    }

    public boolean isHost(TEBase TE) {
        return (TE.getData() & 0x200) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void playStateChangeSound(TEBase TE) {
        Set<TEBase> set = this.getBlocks(TE, BlockRegistry.blockCarpentersGarageDoor);
        ArrayList<TEBase> list = new ArrayList<TEBase>(set);
        Collections.sort(list, new DoorPieceDistanceComparator());
        if (((TEBase)list.get(0)).equals(TE)) {
            TE.func_145831_w().func_72889_a((EntityPlayer)null, 1003, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 0);
        }
    }

    public TEBase findReferencePiece(World world, int x, int y, int z, ForgeDirection axis) {
        ForgeDirection dir = axis.getRotation(ForgeDirection.UP);
        do {
            TEBase temp1 = BlockProperties.getTileEntity(BlockRegistry.blockCarpentersGarageDoor, world, x + dir.offsetX, y, z + dir.offsetZ);
            TEBase temp2 = BlockProperties.getTileEntity(BlockRegistry.blockCarpentersGarageDoor, world, x - dir.offsetX, y, z - dir.offsetZ);
            if (temp1 != null && this.getDirection(temp1).equals((Object)axis)) {
                return temp1;
            }
            if (temp2 == null || !this.getDirection(temp2).equals((Object)axis)) continue;
            return temp2;
        } while (y > 1 && world.func_147439_a(x, --y, z).equals(Blocks.field_150350_a));
        return null;
    }

    public void replicate(TEBase src, TEBase dest) {
        this.setDirection(dest, this.getDirection(src));
        this.setRigidity(dest, this.getRigidity(src));
        this.setState(dest, this.getState(src));
        this.setType(dest, this.getType(src));
        dest.copyOwner(src);
    }

    public boolean isOpen(TEBase TE) {
        return this.getState(TE) == 1;
    }

    public boolean isBottommost(TEBase TE) {
        return !TE.func_145831_w().func_147439_a(TE.field_145851_c, TE.field_145848_d - 1, TE.field_145849_e).equals(BlockRegistry.blockCarpentersGarageDoor);
    }

    public TEBase getTopmost(World world, int x, int y, int z) {
        while (world.func_147439_a(x, ++y, z).equals(BlockRegistry.blockCarpentersGarageDoor)) {
        }
        return (TEBase)world.func_147438_o(x, y - 1, z);
    }

    public TEBase getBottommost(World world, int x, int y, int z) {
        while (world.func_147439_a(x, --y, z).equals(BlockRegistry.blockCarpentersGarageDoor)) {
        }
        return (TEBase)world.func_147438_o(x, y + 1, z);
    }

    public boolean isVisible(TEBase TE) {
        if (this.isOpen(TE)) {
            return this.isHost(TE);
        }
        return true;
    }

    @Override
    public int getMatchingDataPattern(TEBase TE) {
        return TE.getData() & 0x70;
    }

    @Override
    public ForgeDirection[] getLocateDirs(TEBase TE) {
        ForgeDirection dirPlane = this.getDirection(TE).getRotation(ForgeDirection.UP);
        ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN, dirPlane, dirPlane.getOpposite()};
        return dirs;
    }

    @SideOnly(value=Side.CLIENT)
    class DoorPieceDistanceComparator
    implements Comparator<TEBase> {
        DoorPieceDistanceComparator() {
        }

        @Override
        public int compare(TEBase tileEntity1, TEBase tileEntity2) {
            double dist2;
            double dist1 = Minecraft.func_71410_x().field_71439_g.func_70011_f((double)tileEntity1.field_145851_c, (double)tileEntity1.field_145848_d, (double)tileEntity1.field_145849_e);
            return dist1 < (dist2 = Minecraft.func_71410_x().field_71439_g.func_70011_f((double)tileEntity2.field_145851_c, (double)tileEntity2.field_145848_d, (double)tileEntity2.field_145849_e)) ? -1 : 1;
        }
    }
}

