/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.factorization;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.compat.CompatModuleFactorization;
import buildcraft.compat.CompatUtils;
import factorization.common.FactoryType;
import factorization.servo.TileEntityServoRail;
import factorization.sockets.TileEntitySocketBase;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class SchematicFZBase
extends SchematicTile {
    protected static final int[] shiftMatrix = new int[]{0, 1, 5, 4, 2, 3, 6, 7};

    public void rotateLeft(IBuilderContext context) {
        if (this.tileNBT != null) {
            if (this.tileNBT.func_74764_b("facing")) {
                this.tileNBT.func_74774_a("facing", (byte)shiftMatrix[this.tileNBT.func_74771_c("facing") & 7]);
            } else if (this.tileNBT.func_74764_b("side")) {
                this.tileNBT.func_74774_a("side", (byte)shiftMatrix[this.tileNBT.func_74771_c("side") & 7]);
            } else if (this.tileNBT.func_74764_b("fc")) {
                this.tileNBT.func_74774_a("fc", (byte)shiftMatrix[this.tileNBT.func_74771_c("fc") & 7]);
            } else if (this.tileNBT.func_74764_b("dir")) {
                this.tileNBT.func_74774_a("dir", (byte)shiftMatrix[this.tileNBT.func_74771_c("dir") & 7]);
            }
        }
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        if (this.tileNBT != null) {
            this.tileNBT.func_82580_o("draw_active_byte");
            this.tileNBT.func_82580_o("burnTime");
            this.tileNBT.func_82580_o("cookTime");
            this.tileNBT.func_82580_o("store");
            this.tileNBT.func_82580_o("storage");
            this.tileNBT.func_82580_o("charge");
            this.tileNBT.func_82580_o("heat");
            this.tileNBT.func_82580_o("progress");
            this.tileNBT.func_82580_o("prog");
            this.tileNBT.func_82580_o("digest");
            this.tileNBT.func_82580_o("food");
            this.tileNBT.func_82580_o("stomache");
            this.tileNBT.func_82580_o("steam");
            this.tileNBT.func_82580_o("water");
            this.tileNBT.func_82580_o("targetx");
            this.tileNBT.func_82580_o("targety");
            this.tileNBT.func_82580_o("targetz");
            this.tileNBT.func_82580_o("rs");
            this.tileNBT.func_82580_o("root");
            this.tileNBT.func_82580_o("prog");
            if (this.meta == 3) {
                this.tileNBT.func_82580_o("spd");
                this.tileNBT.func_82580_o("prg");
                this.tileNBT.func_82580_o("buf");
                this.tileNBT.func_82580_o("hsh");
                this.tileNBT.func_82580_o("chargecharge");
                this.tileNBT.func_82580_o("pow");
                this.tileNBT.func_82580_o("open");
                this.tileNBT.func_82580_o("wait");
                this.tileNBT.func_82580_o("fanw");
                this.tileNBT.func_82580_o("dropDelay");
                this.tileNBT.func_82580_o("buff");
                this.tileNBT.func_82580_o("auxBuff");
                this.tileNBT.func_82580_o("murderBuff");
                this.tileNBT.func_82580_o("drainTank");
                this.tileNBT.func_82580_o("floodTank");
            }
            if ("factory_battery".equals(this.tileNBT.func_74779_i("id"))) {
                this.tileNBT.func_74768_a("storage", 6400);
            }
        }
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        if (super.isAlreadyBuilt(context, x, y, z)) {
            NBTTagCompound targetNBT = CompatUtils.getTileNBT((IBlockAccess)context.world(), x, y, z);
            return targetNBT.func_74771_c("facing") == this.tileNBT.func_74771_c("facing") && targetNBT.func_74771_c("side") == this.tileNBT.func_74771_c("side") && targetNBT.func_74771_c("fc") == this.tileNBT.func_74771_c("fc") && targetNBT.func_74771_c("dir") == this.tileNBT.func_74771_c("dir");
        }
        return false;
    }

    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        if (!this.doNotBuild()) {
            super.getRequirementsForPlacement(context, requirements);
        }
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        if (!this.doNotBuild()) {
            TileEntity tile;
            if (this.tileNBT != null) {
                if ("factory_battery".equals(this.tileNBT.func_74779_i("id"))) {
                    this.storedRequirements = new ItemStack[1];
                    this.storedRequirements[0] = new ItemStack(Item.func_150898_a((Block)Block.func_149684_b((String)"factorization:charge_battery")), 1, 2);
                    this.storedRequirements[0].func_77982_d(new NBTTagCompound());
                    return;
                }
                if ("factory_leyjar".equals(this.tileNBT.func_74779_i("id"))) {
                    this.storedRequirements = new ItemStack[1];
                    this.storedRequirements[0] = new ItemStack(Item.func_150898_a((Block)Block.func_149684_b((String)"factorization:FzBlock")), 1, 26);
                    return;
                }
            }
            if (this.meta == 3 && (tile = context.world().func_147438_o(x, y, z)) instanceof TileEntitySocketBase) {
                ArrayList<ItemStack> reqs = new ArrayList<ItemStack>();
                FactoryType type = ((TileEntitySocketBase)tile).getFactoryType();
                while (type != null) {
                    TileEntitySocketBase socket = (TileEntitySocketBase)type.getRepresentative();
                    if (socket != null && socket.getCreatingItem() != null) {
                        reqs.add(socket.getCreatingItem());
                    }
                    type = socket.getParentFactoryType();
                }
                reqs.add(FactoryType.SOCKET_EMPTY.itemStack());
                this.storedRequirements = reqs.toArray(new ItemStack[reqs.size()]);
                return;
            }
            if (this.meta == 9 && (tile = context.world().func_147438_o(x, y, z)) instanceof TileEntityServoRail) {
                ArrayList<ItemStack> reqs = new ArrayList<ItemStack>();
                TileEntityServoRail rail = (TileEntityServoRail)tile;
                reqs.add(rail.getDroppedBlock());
                if (rail.getDecoration() != null && !rail.getDecoration().isFreeToPlace()) {
                    reqs.add(rail.getDecoration().toItem());
                }
                this.storedRequirements = reqs.toArray(new ItemStack[reqs.size()]);
                return;
            }
            super.storeRequirements(context, x, y, z);
        }
    }

    public boolean doNotBuild() {
        if (this.tileNBT != null) {
            String id = this.tileNBT.func_74779_i("id");
            if ("factory_hinge".equals(id)) {
                return true;
            }
            if ("factory_rail".equals(id) && !CompatModuleFactorization.ENABLE_SERVO_RAILS) {
                return true;
            }
        }
        return false;
    }
}

