/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.json.JsonVertex;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;

public class JsonQuad {
    public boolean shade = false;
    public int tint = -1;
    public String texture;
    public final JsonVertex[] vertices = new JsonVertex[4];
    public EnumFacing face;

    public JsonQuad(JsonObject obj, float[] from, float[] to, EnumFacing face) {
        this.face = face;
        this.tint = JsonUtils.func_151208_a((JsonObject)obj, (String)"tintindex", (int)-1);
        this.texture = JsonUtils.func_151200_h((JsonObject)obj, (String)"texture");
        int rotation = JsonUtils.func_151208_a((JsonObject)obj, (String)"rotation", (int)0);
        float[] uv = JsonUtil.getSubAsFloatArray(obj, "uv");
        if (uv.length != 4) {
            throw new JsonSyntaxException("Expected exactly 4 floats, but got " + Arrays.toString(uv));
        }
        ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        uvs.minU = uv[0] / 16.0f;
        uvs.minV = uv[1] / 16.0f;
        uvs.maxU = uv[2] / 16.0f;
        uvs.maxV = uv[3] / 16.0f;
        Vector3f radius = new Vector3f(to[0] - from[0], to[1] - from[1], to[2] - from[2]);
        radius.scale(0.5f);
        Vector3f center = new Vector3f(from);
        center.add((Tuple3f)radius);
        MutableQuad quad = ModelUtil.createFace(face, (Tuple3f)center, (Tuple3f)radius, uvs);
        quad.rotateTextureUp(rotation);
        this.vertices[0] = new JsonVertex(quad.vertex_0);
        this.vertices[1] = new JsonVertex(quad.vertex_1);
        this.vertices[2] = new JsonVertex(quad.vertex_2);
        this.vertices[3] = new JsonVertex(quad.vertex_3);
    }

    public MutableQuad toQuad(TextureAtlasSprite sprite) {
        MutableQuad quad = new MutableQuad(this.tint, this.face, this.shade);
        this.vertices[0].loadInto(quad.vertex_0);
        this.vertices[1].loadInto(quad.vertex_1);
        this.vertices[2].loadInto(quad.vertex_2);
        this.vertices[3].loadInto(quad.vertex_3);
        if (sprite != null) {
            quad.texFromSprite(sprite);
            quad.setSprite(sprite);
        }
        return quad;
    }
}

