/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.block;

import buildcraft.api.blocks.ICustomRotationHandler;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.RotationUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IBlockWithFacing
extends ICustomRotationHandler {
    default public boolean canFaceVertically() {
        return false;
    }

    default public IProperty<EnumFacing> getFacingProperty() {
        return this.canFaceVertically() ? BlockBCBase_Neptune.BLOCK_FACING_6 : BlockBCBase_Neptune.PROP_FACING;
    }

    default public boolean canBeRotated(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    default public EnumActionResult attemptRotation(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (!this.canBeRotated(world, pos, state)) {
            return EnumActionResult.FAIL;
        }
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b(this.getFacingProperty());
        EnumFacing newFacing = this.canFaceVertically() ? RotationUtil.rotateAll(currentFacing) : currentFacing.func_176746_e();
        world.func_175656_a(pos, state.func_177226_a(this.getFacingProperty(), (Comparable)newFacing));
        return EnumActionResult.SUCCESS;
    }
}

