/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gen;

import buildcraft.api.enums.EnumSpring;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.core.BCCoreBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SpringPopulate {
    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        World world = event.getWorld();
        Random rand = event.getRand();
        int chunkX = event.getChunkX();
        int chunkZ = event.getChunkZ();
        boolean doGen = TerrainGen.populate((IChunkGenerator)event.getGen(), (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)event.isHasVillageGenerated(), (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen || !EnumSpring.WATER.canGen) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        int worldX = chunkX << 4;
        int worldZ = chunkZ << 4;
        SpringPopulate.doPopulate(world, rand, worldX, worldZ);
    }

    private static void doPopulate(World world, Random random, int x, int z) {
        int dimId = world.field_73011_w.getDimension();
        if (dimId == -1 || dimId == 1) {
            return;
        }
        if (random.nextFloat() > 0.025f) {
            return;
        }
        int posX = x + random.nextInt(16);
        int posZ = z + random.nextInt(16);
        for (int i = 0; i < 5; ++i) {
            BlockPos pos = new BlockPos(posX, i, posZ);
            Block candidate = world.func_180495_p(pos).func_177230_c();
            if (candidate != Blocks.field_150357_h) continue;
            int y = i > 0 ? i : i - 1;
            IBlockState springState = BCCoreBlocks.spring.func_176223_P();
            springState = springState.func_177226_a(BuildCraftProperties.SPRING_TYPE, (Comparable)((Object)EnumSpring.WATER));
            world.func_175656_a(new BlockPos(posX, y, posZ), springState);
            for (int j = y + 2; j < world.func_72800_K() && !world.func_175623_d(new BlockPos(posX, j, posZ)); ++j) {
                world.func_175656_a(new BlockPos(posX, j, posZ), Blocks.field_150355_j.func_176223_P());
            }
            break;
        }
    }
}

