/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.client.render;

import buildcraft.api.core.render.ISprite;
import buildcraft.builders.tile.TileQuarry;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.lib.client.render.laser.LaserBoxRenderer;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.SpriteUtil;
import buildcraft.lib.misc.VecUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class RenderQuarry
extends TileEntitySpecialRenderer<TileQuarry> {
    public static final LaserData_BC8.LaserType FRAME;
    public static final LaserData_BC8.LaserType FRAME_BOTTOM;
    public static final LaserData_BC8.LaserType DRILL;
    public static final LaserData_BC8.LaserType LASER;

    public void render(TileQuarry tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("bc");
        profiler.func_76320_a("quarry");
        profiler.func_76320_a("setup");
        SpriteUtil.bindBlockTextureMap();
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x - (double)tile.func_174877_v().func_177958_n()), (double)(y - (double)tile.func_174877_v().func_177956_o()), (double)(z - (double)tile.func_174877_v().func_177952_p()));
        BlockPos min = tile.frameBox.min();
        BlockPos max = tile.frameBox.max();
        profiler.func_76319_b();
        if (tile.frameBox.isInitialized()) {
            double yOffset = 1.25;
            profiler.func_76320_a("laser");
            if (tile.currentTask != null && tile.currentTask instanceof TileQuarry.TaskBreakBlock) {
                TileQuarry.TaskBreakBlock taskBreakBlock = (TileQuarry.TaskBreakBlock)tile.currentTask;
                BlockPos pos = taskBreakBlock.breakPos;
                if (tile.drillPos == null) {
                    if (taskBreakBlock.clientPower != 0L) {
                        Vec3d from = VecUtil.convertCenter((Vec3i)tile.func_174877_v());
                        Vec3d to = VecUtil.convertCenter((Vec3i)pos);
                        LaserData_BC8 laser = new LaserData_BC8(LASER, from, to, 0.0625);
                        LaserRenderer_BC8.renderLaserStatic(laser);
                    }
                } else {
                    long power = (long)((double)taskBreakBlock.prevClientPower + (double)(taskBreakBlock.clientPower - taskBreakBlock.prevClientPower) * (double)partialTicks);
                    AxisAlignedBB aabb = tile.func_145831_w().func_180495_p(pos).func_185900_c((IBlockAccess)tile.func_145831_w(), pos);
                    double value = (double)power / (double)taskBreakBlock.getTarget();
                    value = value < 0.9 ? 1.0 - value / 0.9 : (value - 0.9) / 0.1;
                    double scaleMin = 1.0 - (1.0 - aabb.field_72337_e) - (aabb.field_72337_e - aabb.field_72338_b) / 2.0;
                    double scaleMax = 1.25;
                    yOffset = scaleMin + value * (scaleMax - scaleMin);
                }
            }
            profiler.func_76318_c("frame");
            if (tile.clientDrillPos != null && tile.prevClientDrillPos != null) {
                Vec3d interpolatedPos = tile.prevClientDrillPos.func_178787_e(tile.clientDrillPos.func_178788_d(tile.prevClientDrillPos).func_186678_a((double)partialTicks));
                LaserRenderer_BC8.renderLaserStatic(new LaserData_BC8(FRAME, new Vec3d(interpolatedPos.field_72450_a + 0.5, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c), new Vec3d(interpolatedPos.field_72450_a + 0.5, (double)max.func_177956_o() + 0.5, (double)max.func_177952_p() + 0.75), 0.0625, true, true, 0));
                LaserRenderer_BC8.renderLaserStatic(new LaserData_BC8(FRAME, new Vec3d(interpolatedPos.field_72450_a + 0.5, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c), new Vec3d(interpolatedPos.field_72450_a + 0.5, (double)max.func_177956_o() + 0.5, (double)min.func_177952_p() + 0.25), 0.0625, true, true, 0));
                LaserRenderer_BC8.renderLaserStatic(new LaserData_BC8(FRAME, new Vec3d(interpolatedPos.field_72450_a, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c + 0.5), new Vec3d((double)max.func_177958_n() + 0.75, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c + 0.5), 0.0625, true, true, 0));
                LaserRenderer_BC8.renderLaserStatic(new LaserData_BC8(FRAME, new Vec3d(interpolatedPos.field_72450_a, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c + 0.5), new Vec3d((double)min.func_177958_n() + 0.25, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c + 0.5), 0.0625, true, true, 0));
                LaserRenderer_BC8.renderLaserStatic(new LaserData_BC8(FRAME_BOTTOM, new Vec3d(interpolatedPos.field_72450_a + 0.5, interpolatedPos.field_72448_b + 1.0 + 0.25, interpolatedPos.field_72449_c + 0.5), new Vec3d(interpolatedPos.field_72450_a + 0.5, (double)max.func_177956_o() + 0.5, interpolatedPos.field_72449_c + 0.5), 0.0625, true, true, 0));
                LaserRenderer_BC8.renderLaserStatic(new LaserData_BC8(DRILL, new Vec3d(interpolatedPos.field_72450_a + 0.5, interpolatedPos.field_72448_b + 1.0 + yOffset, interpolatedPos.field_72449_c + 0.5), new Vec3d(interpolatedPos.field_72450_a + 0.5, interpolatedPos.field_72448_b + yOffset, interpolatedPos.field_72449_c + 0.5), 0.0625, true, true, 0));
            } else {
                LaserBoxRenderer.renderLaserBoxStatic(tile.frameBox, BuildCraftLaserManager.STRIPES_WRITE, true);
            }
            profiler.func_76319_b();
        }
        GlStateManager.func_179121_F();
        profiler.func_76320_a("items");
        if (tile.frameBox.isInitialized()) {
            // empty if block
        }
        RenderHelper.func_74519_b();
        profiler.func_76319_b();
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    public boolean isGlobalRenderer(TileQuarry tile) {
        return true;
    }

    public static void init() {
    }

    static {
        SpriteHolderRegistry.SpriteHolder sprite = SpriteHolderRegistry.getHolder("buildcraftbuilders:blocks/frame/default");
        LaserData_BC8.LaserRow capStart = new LaserData_BC8.LaserRow((ISprite)sprite, 0, 0, 0, 0, new LaserData_BC8.LaserSide[0]);
        LaserData_BC8.LaserRow start = null;
        LaserData_BC8.LaserRow[] middle = new LaserData_BC8.LaserRow[]{new LaserData_BC8.LaserRow((ISprite)sprite, 0, 4, 16, 12, new LaserData_BC8.LaserSide[0])};
        LaserData_BC8.LaserRow end = new LaserData_BC8.LaserRow((ISprite)sprite, 0, 4, 16, 12, new LaserData_BC8.LaserSide[0]);
        LaserData_BC8.LaserRow capEnd = new LaserData_BC8.LaserRow((ISprite)sprite, 0, 0, 0, 0, new LaserData_BC8.LaserSide[0]);
        FRAME = new LaserData_BC8.LaserType(capStart, start, middle, end, capEnd);
        sprite = SpriteHolderRegistry.getHolder("buildcraftbuilders:blocks/frame/default");
        capStart = new LaserData_BC8.LaserRow((ISprite)sprite, 0, 0, 0, 0, new LaserData_BC8.LaserSide[0]);
        start = null;
        middle = new LaserData_BC8.LaserRow[]{new LaserData_BC8.LaserRow((ISprite)sprite, 0, 4, 16, 12, new LaserData_BC8.LaserSide[0])};
        end = new LaserData_BC8.LaserRow((ISprite)sprite, 0, 4, 16, 12, new LaserData_BC8.LaserSide[0]);
        capEnd = new LaserData_BC8.LaserRow((ISprite)sprite, 4, 4, 12, 12, new LaserData_BC8.LaserSide[0]);
        FRAME_BOTTOM = new LaserData_BC8.LaserType(capStart, start, middle, end, capEnd);
        sprite = SpriteHolderRegistry.getHolder("buildcraftbuilders:blocks/quarry/drill");
        capStart = new LaserData_BC8.LaserRow((ISprite)sprite, 6, 0, 10, 4, new LaserData_BC8.LaserSide[0]);
        start = null;
        middle = new LaserData_BC8.LaserRow[]{new LaserData_BC8.LaserRow((ISprite)sprite, 0, 0, 16, 4, new LaserData_BC8.LaserSide[0])};
        end = null;
        capEnd = new LaserData_BC8.LaserRow((ISprite)sprite, 6, 0, 10, 4, new LaserData_BC8.LaserSide[0]);
        DRILL = new LaserData_BC8.LaserType(capStart, start, middle, end, capEnd);
        LASER = BuildCraftLaserManager.POWER_LOW;
    }
}

