/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.BCModules;
import buildcraft.api.IBuildCraftMod;
import buildcraft.api.core.BCLog;
import buildcraft.builders.BCBuildersConfig;
import buildcraft.builders.BCBuildersGuis;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.builders.client.render.RenderArchitectTable;
import buildcraft.builders.client.render.RenderArchitectTables;
import buildcraft.builders.client.render.RenderBuilder;
import buildcraft.builders.client.render.RenderFiller;
import buildcraft.builders.client.render.RenderQuarry;
import buildcraft.builders.container.ContainerArchitectTable;
import buildcraft.builders.container.ContainerBuilder;
import buildcraft.builders.container.ContainerElectronicLibrary;
import buildcraft.builders.container.ContainerFiller;
import buildcraft.builders.container.ContainerFillerPlanner;
import buildcraft.builders.container.ContainerReplacer;
import buildcraft.builders.gui.GuiArchitectTable;
import buildcraft.builders.gui.GuiBuilder;
import buildcraft.builders.gui.GuiElectronicLibrary;
import buildcraft.builders.gui.GuiFiller;
import buildcraft.builders.gui.GuiFillerPlanner;
import buildcraft.builders.gui.GuiReplacer;
import buildcraft.builders.snapshot.MessageSnapshotRequest;
import buildcraft.builders.snapshot.MessageSnapshotResponse;
import buildcraft.builders.tile.TileArchitectTable;
import buildcraft.builders.tile.TileBuilder;
import buildcraft.builders.tile.TileElectronicLibrary;
import buildcraft.builders.tile.TileFiller;
import buildcraft.builders.tile.TileQuarry;
import buildcraft.builders.tile.TileReplacer;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.net.MessageManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCBuildersProxy
implements IGuiHandler {
    @SidedProxy
    private static BCBuildersProxy proxy;

    public static BCBuildersProxy getProxy() {
        return proxy;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (id == BCBuildersGuis.LIBRARY.ordinal() && tile instanceof TileElectronicLibrary) {
            TileElectronicLibrary electronicLibrary = (TileElectronicLibrary)tile;
            return new ContainerElectronicLibrary(player, electronicLibrary);
        }
        if (id == BCBuildersGuis.BUILDER.ordinal() && tile instanceof TileBuilder) {
            TileBuilder builder = (TileBuilder)tile;
            return new ContainerBuilder(player, builder);
        }
        if (id == BCBuildersGuis.FILLER.ordinal() && tile instanceof TileFiller) {
            TileFiller filler = (TileFiller)tile;
            return new ContainerFiller(player, filler);
        }
        if (id == BCBuildersGuis.ARCHITECT.ordinal() && tile instanceof TileArchitectTable) {
            TileArchitectTable architectTable = (TileArchitectTable)tile;
            return new ContainerArchitectTable(player, architectTable);
        }
        if (id == BCBuildersGuis.REPLACER.ordinal() && tile instanceof TileReplacer) {
            TileReplacer replacer = (TileReplacer)tile;
            return new ContainerReplacer(player, replacer);
        }
        if (id == BCBuildersGuis.FILLER_PLANNER.ordinal()) {
            return new ContainerFillerPlanner(player);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void fmlPreInit() {
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.BUILDERS, MessageSnapshotRequest.class, MessageSnapshotRequest.HANDLER, Side.SERVER);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.BUILDERS, MessageSnapshotResponse.class, Side.CLIENT);
    }

    public void fmlInit() {
    }

    public void fmlPostInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCBuildersProxy {
        @Override
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (id == BCBuildersGuis.LIBRARY.ordinal() && tile instanceof TileElectronicLibrary) {
                TileElectronicLibrary library = (TileElectronicLibrary)tile;
                return new GuiElectronicLibrary(new ContainerElectronicLibrary(player, library));
            }
            if (id == BCBuildersGuis.BUILDER.ordinal() && tile instanceof TileBuilder) {
                TileBuilder builder = (TileBuilder)tile;
                return new GuiBuilder(new ContainerBuilder(player, builder));
            }
            if (id == BCBuildersGuis.FILLER.ordinal() && tile instanceof TileFiller) {
                TileFiller filler = (TileFiller)tile;
                return new GuiFiller(new ContainerFiller(player, filler));
            }
            if (id == BCBuildersGuis.ARCHITECT.ordinal() && tile instanceof TileArchitectTable) {
                TileArchitectTable architectTable = (TileArchitectTable)tile;
                return new GuiArchitectTable(new ContainerArchitectTable(player, architectTable));
            }
            if (id == BCBuildersGuis.REPLACER.ordinal() && tile instanceof TileReplacer) {
                TileReplacer replacer = (TileReplacer)tile;
                return new GuiReplacer(new ContainerReplacer(player, replacer));
            }
            if (id == BCBuildersGuis.FILLER_PLANNER.ordinal()) {
                return new GuiFillerPlanner(new ContainerFillerPlanner(player));
            }
            return null;
        }

        @Override
        public void fmlPreInit() {
            super.fmlPreInit();
            if (BCBuildersConfig.enableStencil) {
                if (BCBuildersConfig.internalStencilCrashTest.getBoolean()) {
                    BCLog.logger.warn("[builders.architect] Not enabling stencils because they have been force-disabled!");
                } else {
                    BCBuildersConfig.internalStencilCrashTest.set(true);
                    BCCoreConfig.saveConfigs();
                    Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
                    if (!framebuffer.isStencilEnabled()) {
                        framebuffer.enableStencil();
                    }
                    BCBuildersConfig.internalStencilCrashTest.set(false);
                    BCCoreConfig.saveConfigs();
                }
            }
            BCBuildersSprites.fmlPreInit();
            RenderQuarry.init();
            MessageManager.setHandler(MessageSnapshotResponse.class, MessageSnapshotResponse.HANDLER, Side.CLIENT);
        }

        @Override
        public void fmlInit() {
            super.fmlInit();
            ClientRegistry.bindTileEntitySpecialRenderer(TileArchitectTable.class, (TileEntitySpecialRenderer)new RenderArchitectTable());
            ClientRegistry.bindTileEntitySpecialRenderer(TileBuilder.class, (TileEntitySpecialRenderer)new RenderBuilder());
            ClientRegistry.bindTileEntitySpecialRenderer(TileFiller.class, (TileEntitySpecialRenderer)new RenderFiller());
            ClientRegistry.bindTileEntitySpecialRenderer(TileQuarry.class, (TileEntitySpecialRenderer)new RenderQuarry());
            DetachedRenderer.INSTANCE.addRenderer(DetachedRenderer.RenderMatrixType.FROM_WORLD_ORIGIN, RenderArchitectTables.INSTANCE);
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCBuildersProxy {
    }
}

