/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.wire;

import buildcraft.transport.wire.ClientWireSystems;
import buildcraft.transport.wire.WireSystem;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class MessageWireSystems
implements IMessage {
    private Map<Integer, WireSystem> wireSystems = new HashMap<Integer, WireSystem>();
    public static final IMessageHandler<MessageWireSystems, IMessage> HANDLER = (message, ctx) -> {
        ClientWireSystems.INSTANCE.wireSystems.clear();
        ClientWireSystems.INSTANCE.wireSystems.putAll(message.wireSystems);
        return null;
    };

    public MessageWireSystems() {
    }

    public MessageWireSystems(Map<Integer, WireSystem> wireSystems) {
        this.wireSystems = wireSystems;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.writeInt(this.wireSystems.size());
        this.wireSystems.forEach((wiresHashCode, wireSystem) -> {
            pb.writeInt(wiresHashCode.intValue());
            List<WireSystem.WireElement> elements = wireSystem.elements.stream().filter(element -> element.type == WireSystem.WireElement.Type.WIRE_PART).collect(Collectors.toList());
            pb.writeInt(elements.size());
            elements.forEach(element -> element.toBytes(pb));
        });
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.wireSystems.clear();
        int count = pb.readInt();
        for (int i = 0; i < count; ++i) {
            WireSystem wireSystem = new WireSystem();
            int wiresHashCode = pb.readInt();
            int localCount = pb.readInt();
            for (int j = 0; j < localCount; ++j) {
                wireSystem.elements.add(new WireSystem.WireElement(pb));
            }
            this.wireSystems.put(wiresHashCode, wireSystem);
        }
    }
}

