/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.item;

import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.silicon.BCSiliconPlugs;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadePhasedState;
import buildcraft.silicon.plug.FacadeStateManager;
import buildcraft.silicon.plug.PluggableFacade;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemPluggableFacade
extends ItemBC_Neptune
implements IItemPluggable,
IFacadeItem {
    public ItemPluggableFacade(String id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Nonnull
    public ItemStack createItemStack(FacadeInstance state) {
        ItemStack item = new ItemStack((Item)this);
        NBTTagCompound nbt = NBTUtilBC.getItemData(item);
        nbt.func_74782_a("facade", (NBTBase)state.writeToNbt());
        return item;
    }

    public static FacadeInstance getStates(@Nonnull ItemStack item) {
        NBTTagList states;
        NBTTagCompound nbt = NBTUtilBC.getItemData(item);
        String strPreview = nbt.func_74779_i("preview");
        if ("basic".equalsIgnoreCase(strPreview)) {
            return FacadeInstance.createSingle(FacadeStateManager.previewState, false);
        }
        if (!nbt.func_74764_b("facade") && nbt.func_74764_b("states") && (states = nbt.func_150295_c("states", 10)).func_74745_c() > 0) {
            boolean isHollow = states.func_150305_b(0).func_74767_n("isHollow");
            NBTTagCompound tagFacade = new NBTTagCompound();
            tagFacade.func_74757_a("isHollow", isHollow);
            tagFacade.func_74782_a("states", (NBTBase)states);
            nbt.func_74782_a("facade", (NBTBase)tagFacade);
        }
        return FacadeInstance.readFromNbt(nbt.func_74775_l("facade"));
    }

    @Override
    @Nonnull
    public ItemStack getFacadeForBlock(IBlockState state) {
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)FacadeStateManager.validFacadeStates.get(state);
        if (info == null) {
            return StackUtil.EMPTY;
        }
        return this.createItemStack(FacadeInstance.createSingle(info, false));
    }

    @Override
    public PipePluggable onPlace(@Nonnull ItemStack stack, IPipeHolder holder, EnumFacing side, EntityPlayer player, EnumHand hand) {
        FacadeInstance fullState = ItemPluggableFacade.getStates(stack);
        SoundUtil.playBlockPlace(holder.getPipeWorld(), holder.getPipePos(), fullState.phasedStates[0].stateInfo.state);
        return new PluggableFacade(BCSiliconPlugs.facade, holder, side, fullState);
    }

    @Override
    public void addSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        FacadeBlockStateInfo stone = FacadeStateManager.getInfoForBlock(Blocks.field_150348_b);
        if (stone != null) {
            FacadePhasedState[] states = new FacadePhasedState[]{FacadeStateManager.getInfoForBlock(Blocks.field_150348_b).createPhased(null), FacadeStateManager.getInfoForBlock(Blocks.field_150344_f).createPhased(EnumDyeColor.RED), FacadeStateManager.getInfoForBlock(Blocks.field_150364_r).createPhased(EnumDyeColor.CYAN)};
            FacadeInstance inst = new FacadeInstance(states, false);
            subItems.add((Object)this.createItemStack(inst));
            for (FacadeBlockStateInfo info : FacadeStateManager.validFacadeStates.values()) {
                if (!ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)info.state.func_177230_c()) || !info.isVisible) continue;
                subItems.add((Object)this.createItemStack(FacadeInstance.createSingle(info, false)));
                subItems.add((Object)this.createItemStack(FacadeInstance.createSingle(info, true)));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        FacadeInstance fullState = ItemPluggableFacade.getStates(stack);
        if (fullState.type == FacadeType.Basic) {
            String displayName = ItemPluggableFacade.getFacadeStateDisplayName(fullState.phasedStates[0]);
            return super.func_77653_i(stack) + ": " + displayName;
        }
        return LocaleUtil.localize("item.FacadePhased.name");
    }

    public static String getFacadeStateDisplayName(FacadePhasedState state) {
        ItemStack assumedStack = state.stateInfo.requiredStack;
        return assumedStack.func_82833_r();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        FacadeInstance states = ItemPluggableFacade.getStates(stack);
        if (states.type == FacadeType.Phased) {
            String stateString = LocaleUtil.localize("item.FacadePhased.state");
            FacadePhasedState defaultState = null;
            for (FacadePhasedState state : states.phasedStates) {
                if (state.activeColour == null) {
                    defaultState = state;
                    continue;
                }
                tooltip.add(String.format(stateString, LocaleUtil.localizeColour(state.activeColour), ItemPluggableFacade.getFacadeStateDisplayName(state)));
            }
            if (defaultState != null) {
                tooltip.add(1, String.format(LocaleUtil.localize("item.FacadePhased.state_default"), ItemPluggableFacade.getFacadeStateDisplayName(defaultState)));
            }
        } else {
            if (flag.func_194127_a()) {
                tooltip.add(states.phasedStates[0].stateInfo.state.func_177230_c().getRegistryName().toString());
            }
            String propertiesStart = TextFormatting.GRAY + "" + TextFormatting.ITALIC;
            FacadeBlockStateInfo info = states.phasedStates[0].stateInfo;
            BlockUtil.getPropertiesStringMap(info.state, info.varyingProperties).forEach((name, value) -> tooltip.add(propertiesStart + name + " = " + value));
        }
    }

    @Override
    public ItemStack createFacadeStack(IFacade facade) {
        return this.createItemStack((FacadeInstance)facade);
    }

    @Override
    public IFacade getFacade(ItemStack facade) {
        return ItemPluggableFacade.getStates(facade);
    }
}

