/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.tile.item;

import buildcraft.api.core.EnumPipePart;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.tile.item.CombinedItemHandlerWrapper;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.lib.tile.item.StackChangeCallback;
import buildcraft.lib.tile.item.StackInsertionChecker;
import buildcraft.lib.tile.item.StackInsertionFunction;
import buildcraft.lib.tile.item.WrappedItemHandlerExtract;
import buildcraft.lib.tile.item.WrappedItemHandlerInsert;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerManager
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public final StackChangeCallback callback;
    private final List<IItemHandlerModifiable> handlersToDrop = new ArrayList<IItemHandlerModifiable>();
    private final Map<EnumPipePart, Wrapper> wrappers = new EnumMap<EnumPipePart, Wrapper>(EnumPipePart.class);
    private final Map<String, INBTSerializable<NBTTagCompound>> handlers = new HashMap<String, INBTSerializable<NBTTagCompound>>();

    public ItemHandlerManager(StackChangeCallback defaultCallback) {
        this.callback = defaultCallback;
        for (EnumPipePart part : EnumPipePart.VALUES) {
            this.wrappers.put(part, new Wrapper());
        }
    }

    public <T extends INBTSerializable<NBTTagCompound> & IItemHandlerModifiable> T addInvHandler(String key, T handler, EnumAccess access, EnumPipePart ... parts) {
        if (parts == null) {
            parts = new EnumPipePart[]{};
        }
        IItemHandlerModifiable external = handler;
        if (access == EnumAccess.NONE || access == EnumAccess.PHANTOM) {
            external = null;
            if (parts.length > 0) {
                throw new IllegalArgumentException("Completely useless to not allow access to multiple sides! Just don't pass any sides!");
            }
        } else if (access == EnumAccess.EXTRACT) {
            external = new WrappedItemHandlerExtract(handler);
        } else if (access == EnumAccess.INSERT) {
            external = new WrappedItemHandlerInsert(handler);
        }
        if (external != null) {
            EnumSet<EnumPipePart> visited = EnumSet.noneOf(EnumPipePart.class);
            for (EnumPipePart part : parts) {
                if (part == null) {
                    part = EnumPipePart.CENTER;
                }
                if (!visited.add(part)) continue;
                Wrapper wrapper = this.wrappers.get((Object)part);
                wrapper.handlers.add(external);
                wrapper.genWrapper();
            }
        }
        if (access != EnumAccess.PHANTOM) {
            this.handlersToDrop.add(handler);
        }
        this.handlers.put(key, handler);
        return handler;
    }

    public ItemHandlerSimple addInvHandler(String key, int size, EnumAccess access, EnumPipePart ... parts) {
        ItemHandlerSimple handler = new ItemHandlerSimple(size, this.callback);
        return this.addInvHandler(key, handler, access, parts);
    }

    public ItemHandlerSimple addInvHandler(String key, int size, StackInsertionChecker checker, EnumAccess access, EnumPipePart ... parts) {
        ItemHandlerSimple handler = new ItemHandlerSimple(size, this.callback);
        handler.setChecker(checker);
        return this.addInvHandler(key, handler, access, parts);
    }

    public ItemHandlerSimple addInvHandler(String key, int size, StackInsertionFunction insertionFunction, EnumAccess access, EnumPipePart ... parts) {
        ItemHandlerSimple handler = new ItemHandlerSimple(size, this.callback);
        handler.setInsertor(insertionFunction);
        return this.addInvHandler(key, handler, access, parts);
    }

    public ItemHandlerSimple addInvHandler(String key, int size, StackInsertionChecker checker, StackInsertionFunction insertionFunction, EnumAccess access, EnumPipePart ... parts) {
        ItemHandlerSimple handler = new ItemHandlerSimple(size, checker, insertionFunction, this.callback);
        return this.addInvHandler(key, handler, access, parts);
    }

    public void addDrops(NonNullList<ItemStack> toDrop) {
        for (IItemHandlerModifiable itemHandler : this.handlersToDrop) {
            InventoryUtil.addAll((IItemHandler)itemHandler, toDrop);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapUtil.CAP_ITEMS) {
            Wrapper wrapper = this.wrappers.get((Object)EnumPipePart.fromFacing(facing));
            return wrapper.combined != null;
        }
        return false;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapUtil.CAP_ITEMS) {
            Wrapper wrapper = this.wrappers.get((Object)EnumPipePart.fromFacing(facing));
            return (T)CapUtil.CAP_ITEMS.cast((Object)wrapper.combined);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, INBTSerializable<NBTTagCompound>> entry : this.handlers.entrySet()) {
            String key = entry.getKey();
            nbt.func_74782_a(key, entry.getValue().serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (Map.Entry<String, INBTSerializable<NBTTagCompound>> entry : this.handlers.entrySet()) {
            String key = entry.getKey();
            entry.getValue().deserializeNBT((NBTBase)nbt.func_74775_l(key));
        }
    }

    private static class Wrapper {
        private final List<IItemHandlerModifiable> handlers = new ArrayList<IItemHandlerModifiable>();
        private IItemHandlerModifiable combined = null;

        private Wrapper() {
        }

        public void genWrapper() {
            if (this.handlers.size() == 1) {
                this.combined = this.handlers.get(0);
                return;
            }
            IItemHandlerModifiable[] arr = new IItemHandlerModifiable[this.handlers.size()];
            arr = this.handlers.toArray(arr);
            this.combined = new CombinedItemHandlerWrapper(arr);
        }
    }

    public static enum EnumAccess {
        NONE,
        PHANTOM,
        INSERT,
        EXTRACT,
        BOTH;

    }
}

