/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.api.recipes.IIntegrationRecipeRegistry;
import buildcraft.api.recipes.IntegrationRecipe;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class IntegrationRecipeRegistry
implements IIntegrationRecipeRegistry {
    public static final IntegrationRecipeRegistry INSTANCE = new IntegrationRecipeRegistry();
    public final Map<ResourceLocation, IntegrationRecipe> recipes = new HashMap<ResourceLocation, IntegrationRecipe>();

    @Override
    public IntegrationRecipe getRecipeFor(@Nonnull ItemStack target, @Nonnull NonNullList<ItemStack> toIntegrate) {
        for (IntegrationRecipe recipe : this.recipes.values()) {
            if (recipe.getOutput(target, toIntegrate).func_190926_b()) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void addRecipe(IntegrationRecipe recipe) {
        if (this.recipes.containsKey(recipe.name)) {
            throw new IllegalStateException("Trying to override integration recipe with name " + recipe.name + ".\nIf you want replace recipe remove old one first.");
        }
        this.recipes.put(recipe.name, recipe);
    }

    @Override
    public Iterable<IntegrationRecipe> getAllRecipes() {
        return this.recipes.values();
    }

    @Override
    public IntegrationRecipe getRecipe(@Nonnull ResourceLocation name) {
        return this.recipes.get(name);
    }
}

