/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.world.WorldEventListenerAdapter;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DebuggingTools {
    public static final boolean ENABLE = BCDebugging.shouldDebugComplex("lib.debug.world");

    public static void fmlInit() {
        if (ENABLE) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHook());
        }
    }

    private static class WorldListener
    extends WorldEventListenerAdapter {
        private WorldListener() {
        }

        @Override
        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
            int i;
            StackTraceElement[] elements = new Throwable().getStackTrace();
            String[] bc = new String[elements.length];
            int bcIndex = 0;
            for (i = 1; i < elements.length; ++i) {
                StackTraceElement ste = elements[i];
                if (!ste.getClassName().startsWith("buildcraft")) continue;
                bc[bcIndex++] = ste.getClassName() + " # " + ste.getMethodName() + " : " + ste.getLineNumber();
            }
            if (bcIndex > 0) {
                BCLog.logger.info("[lib.debug.world] markBlockRangeForRenderUpdate(" + x1 + ", " + y1 + ", " + z1 + ", " + x2 + ", " + y2 + ", " + z2 + ")");
                for (i = 0; i < bcIndex; ++i) {
                    BCLog.logger.info("[lib.debug.world]   at " + bc[i]);
                }
            }
        }
    }

    private static class EventHook {
        private EventHook() {
        }

        @SubscribeEvent
        public void worldLoadEvent(WorldEvent.Load load) {
            load.getWorld().func_72954_a((IWorldEventListener)new WorldListener());
        }
    }
}

