/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.ledger;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.misc.SpriteUtil;
import buildcraft.lib.tile.TileBC_Neptune;
import com.mojang.authlib.GameProfile;
import net.minecraft.util.ResourceLocation;

public class LedgerOwnership
extends Ledger_Neptune {
    private final TileBC_Neptune tile;

    public LedgerOwnership(BuildCraftGui gui, TileBC_Neptune tile, boolean expandPositive) {
        super(gui, -2035457, expandPositive);
        this.title = "gui.ledger.ownership";
        this.tile = tile;
        this.appendText(this::getOwnerName, 0);
        this.calculateMaxSize();
        this.setOpenProperty(GuiConfigManager.getOrAddBoolean(new ResourceLocation("buildcraftlib:base"), "ledger.owner.is_open", false));
    }

    @Override
    protected void drawIcon(double x, double y) {
        ISprite sprite = SpriteUtil.getFaceSprite(this.tile.getOwner());
        GuiIcon.draw(sprite, x, y, x + 16.0, y + 16.0);
        sprite = SpriteUtil.getFaceOverlaySprite(this.tile.getOwner());
        if (sprite != null) {
            GuiIcon.draw(sprite, x - 0.5, y - 0.5, x + 17.0, y + 17.0);
        }
    }

    private String getOwnerName() {
        GameProfile owner = this.tile.getOwner();
        if (owner == null) {
            return "no-one";
        }
        return owner.getName();
    }
}

