/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.lib.client.model.MutableQuad;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class ModelUtil {
    public static MutableQuad createFace(EnumFacing face, Tuple3f a, Tuple3f b, Tuple3f c, Tuple3f d, UvFaceData uvs) {
        MutableQuad quad = new MutableQuad(-1, face);
        if (uvs == null) {
            uvs = UvFaceData.DEFAULT;
        }
        if (face == null || ModelUtil.shouldInvertForRender(face)) {
            quad.vertex_0.positionv(a).texf(uvs.minU, uvs.minV);
            quad.vertex_1.positionv(b).texf(uvs.minU, uvs.maxV);
            quad.vertex_2.positionv(c).texf(uvs.maxU, uvs.maxV);
            quad.vertex_3.positionv(d).texf(uvs.maxU, uvs.minV);
        } else {
            quad.vertex_3.positionv(a).texf(uvs.minU, uvs.minV);
            quad.vertex_2.positionv(b).texf(uvs.minU, uvs.maxV);
            quad.vertex_1.positionv(c).texf(uvs.maxU, uvs.maxV);
            quad.vertex_0.positionv(d).texf(uvs.maxU, uvs.minV);
        }
        return quad;
    }

    public static <T extends Tuple3f> MutableQuad createFace(EnumFacing face, T[] points, UvFaceData uvs) {
        return ModelUtil.createFace(face, points[0], points[1], points[2], points[3], uvs);
    }

    public static MutableQuad createFace(EnumFacing face, Tuple3f center, Tuple3f radius, UvFaceData uvs) {
        Point3f[] points = ModelUtil.getPointsForFace(face, center, radius);
        return ModelUtil.createFace((EnumFacing)face, (Tuple3f[])points, (UvFaceData)uvs).normalf(face.func_82601_c(), face.func_96559_d(), face.func_82599_e());
    }

    public static MutableQuad createInverseFace(EnumFacing face, Tuple3f center, Tuple3f radius, UvFaceData uvs) {
        return ModelUtil.createFace(face, center, radius, uvs).copyAndInvertNormal();
    }

    public static MutableQuad[] createDoubleFace(EnumFacing face, Tuple3f center, Tuple3f radius, UvFaceData uvs) {
        MutableQuad norm = ModelUtil.createFace(face, center, radius, uvs);
        return new MutableQuad[]{norm, norm.copyAndInvertNormal()};
    }

    public static void mapBoxToUvs(AxisAlignedBB box, EnumFacing side, UvFaceData uvs) {
        switch (side) {
            case WEST: {
                uvs.minU = (float)box.field_72339_c;
                uvs.maxU = (float)box.field_72334_f;
                uvs.minV = 1.0f - (float)box.field_72337_e;
                uvs.maxV = 1.0f - (float)box.field_72338_b;
                return;
            }
            case EAST: {
                uvs.minU = 1.0f - (float)box.field_72339_c;
                uvs.maxU = 1.0f - (float)box.field_72334_f;
                uvs.minV = 1.0f - (float)box.field_72337_e;
                uvs.maxV = 1.0f - (float)box.field_72338_b;
                return;
            }
            case DOWN: {
                uvs.minU = (float)box.field_72340_a;
                uvs.maxU = (float)box.field_72336_d;
                uvs.minV = 1.0f - (float)box.field_72334_f;
                uvs.maxV = 1.0f - (float)box.field_72339_c;
                return;
            }
            case UP: {
                uvs.minU = (float)box.field_72340_a;
                uvs.maxU = (float)box.field_72336_d;
                uvs.minV = (float)box.field_72334_f;
                uvs.maxV = (float)box.field_72339_c;
                return;
            }
            case NORTH: {
                uvs.minU = 1.0f - (float)box.field_72340_a;
                uvs.maxU = 1.0f - (float)box.field_72336_d;
                uvs.minV = 1.0f - (float)box.field_72337_e;
                uvs.maxV = 1.0f - (float)box.field_72338_b;
                return;
            }
            case SOUTH: {
                uvs.minU = (float)box.field_72340_a;
                uvs.maxU = (float)box.field_72336_d;
                uvs.minV = 1.0f - (float)box.field_72337_e;
                uvs.maxV = 1.0f - (float)box.field_72338_b;
                return;
            }
        }
        throw new IllegalStateException("Unknown Direction " + side);
    }

    public static Point3f[] getPointsForFace(EnumFacing face, Tuple3f center, Tuple3f radius) {
        Point3f centerOfFace = new Point3f(center);
        Point3f faceAdd = new Point3f((float)face.func_82601_c() * radius.x, (float)face.func_96559_d() * radius.y, (float)face.func_82599_e() * radius.z);
        centerOfFace.add((Tuple3f)faceAdd);
        Vector3f faceRadius = new Vector3f(radius);
        if (face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            faceRadius.sub((Tuple3f)faceAdd);
        } else {
            faceRadius.add((Tuple3f)faceAdd);
        }
        return ModelUtil.getPoints(centerOfFace, (Tuple3f)faceRadius);
    }

    public static Point3f[] getPoints(Point3f centerFace, Tuple3f faceRadius) {
        Point3f[] array = new Point3f[]{new Point3f(centerFace), new Point3f(centerFace), new Point3f(centerFace), new Point3f(centerFace)};
        array[0].add((Tuple3f)ModelUtil.addOrNegate(faceRadius, false, false));
        array[1].add((Tuple3f)ModelUtil.addOrNegate(faceRadius, false, true));
        array[2].add((Tuple3f)ModelUtil.addOrNegate(faceRadius, true, true));
        array[3].add((Tuple3f)ModelUtil.addOrNegate(faceRadius, true, false));
        return array;
    }

    public static Vector3f addOrNegate(Tuple3f coord, boolean u, boolean v) {
        boolean zisv = coord.x != 0.0f && coord.y == 0.0f;
        float x = coord.x * (float)(u ? 1 : -1);
        float y = coord.y * (float)(v ? -1 : 1);
        float z = coord.z * (float)(zisv ? (v ? -1 : 1) : (u ? 1 : -1));
        Vector3f neg = new Vector3f(x, y, z);
        return neg;
    }

    public static boolean shouldInvertForRender(EnumFacing face) {
        boolean flip;
        boolean bl = flip = face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (face.func_176740_k() == EnumFacing.Axis.Z) {
            flip = !flip;
        }
        return flip;
    }

    public static EnumFacing faceForRender(EnumFacing face) {
        if (ModelUtil.shouldInvertForRender(face)) {
            return face.func_176734_d();
        }
        return face;
    }

    public static class TexturedFace {
        public TextureAtlasSprite sprite;
        public UvFaceData faceData = new UvFaceData();
    }

    public static class UvFaceData {
        private static final UvFaceData DEFAULT = new UvFaceData(0.0f, 0.0f, 1.0f, 1.0f);
        public float minU;
        public float maxU;
        public float minV;
        public float maxV;

        public UvFaceData() {
        }

        public UvFaceData(UvFaceData from) {
            this.minU = from.minU;
            this.maxU = from.maxU;
            this.minV = from.minV;
            this.maxV = from.maxV;
        }

        public static UvFaceData from16(double minU, double minV, double maxU, double maxV) {
            return new UvFaceData(minU / 16.0, minV / 16.0, maxU / 16.0, maxV / 16.0);
        }

        public static UvFaceData from16(int minU, int minV, int maxU, int maxV) {
            return new UvFaceData((float)minU / 16.0f, (float)minV / 16.0f, (float)maxU / 16.0f, (float)maxV / 16.0f);
        }

        public UvFaceData(float uMin, float vMin, float uMax, float vMax) {
            this.minU = uMin;
            this.maxU = uMax;
            this.minV = vMin;
            this.maxV = vMax;
        }

        public UvFaceData(double minU, double minV, double maxU, double maxV) {
            this((float)minU, (float)minV, (float)maxU, (float)maxV);
        }

        public UvFaceData andSub(UvFaceData sub) {
            float size_u = this.maxU - this.minU;
            float size_v = this.maxV - this.minV;
            float min_u = this.minU + sub.minU * size_u;
            float min_v = this.minV + sub.minV * size_v;
            float max_u = this.minU + sub.maxU * size_u;
            float max_v = this.minV + sub.maxV * size_v;
            return new UvFaceData(min_u, min_v, max_u, max_v);
        }

        public UvFaceData inParent(UvFaceData parent) {
            return parent.andSub(this);
        }

        public String toString() {
            return "[ " + this.minU * 16.0f + ", " + this.minV * 16.0f + ", " + this.maxU * 16.0f + ", " + this.maxV * 16.0f + " ]";
        }
    }
}

