/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.ModelHolder;
import buildcraft.lib.client.sprite.AtlasSpriteVariants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class ModelHolderRegistry {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.model.holder");
    static final List<ModelHolder> HOLDERS = new ArrayList<ModelHolder>();

    public static void onTextureStitchPre(TextureMap map) {
        HashSet<ResourceLocation> toStitch = new HashSet<ResourceLocation>();
        for (ModelHolder holder : HOLDERS) {
            holder.onTextureStitchPre(toStitch);
        }
        for (ResourceLocation res : toStitch) {
            map.setTextureEntry(AtlasSpriteVariants.createForConfig(res));
        }
    }

    public static void onModelBake() {
        for (ModelHolder holder : HOLDERS) {
            holder.onModelBake();
        }
        if (DEBUG && Loader.instance().isInState(LoaderState.AVAILABLE)) {
            BCLog.logger.info("[lib.model.holder] List of registered Models:");
            ArrayList<ModelHolder> holders = new ArrayList<ModelHolder>();
            holders.addAll(HOLDERS);
            holders.sort(Comparator.comparing(a -> a.modelLocation.toString()));
            for (ModelHolder holder : holders) {
                String status = "  ";
                if (holder.failReason != null) {
                    status = status + "(" + holder.failReason + ")";
                } else if (!holder.hasBakedQuads()) {
                    status = status + "(Model was registered too late)";
                }
                BCLog.logger.info("  - " + holder.modelLocation + status);
            }
            BCLog.logger.info("[lib.model.holder] Total of " + HOLDERS.size() + " models");
        }
    }
}

