/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker;

import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.PathSubCache;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.marker.MarkerConnection;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.VecUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PathConnection
extends MarkerConnection<PathConnection> {
    private static final double RENDER_SCALE = 0.06230529595015576;
    private static final Vec3d VEC_HALF = new Vec3d(0.5, 0.5, 0.5);
    private final Deque<BlockPos> positions = new LinkedList<BlockPos>();
    private boolean loop = false;

    public static boolean tryCreateConnection(PathSubCache subCache, BlockPos from, BlockPos to) {
        PathConnection connection = new PathConnection(subCache);
        connection.positions.add(from);
        connection.positions.add(to);
        subCache.addConnection(connection);
        return true;
    }

    public PathConnection(MarkerSubCache<PathConnection> subCache) {
        super(subCache);
    }

    public PathConnection(PathSubCache subCache, List<BlockPos> positions) {
        super(subCache);
        for (BlockPos p : positions) {
            if (p.equals((Object)this.positions.peekFirst())) {
                this.loop = true;
                break;
            }
            this.positions.addLast(p);
        }
    }

    @Override
    public void removeMarker(BlockPos pos) {
        if (this.positions.getFirst().equals((Object)pos)) {
            this.positions.removeFirst();
            this.loop = false;
            if (this.positions.size() < 2) {
                this.positions.clear();
            }
            this.subCache.refreshConnection(this);
        } else if (this.positions.getLast().equals((Object)pos)) {
            this.positions.removeLast();
            this.loop = false;
            if (this.positions.size() < 2) {
                this.positions.clear();
            }
            this.subCache.refreshConnection(this);
        } else if (this.positions.contains(pos)) {
            ArrayList<BlockPos> a = new ArrayList<BlockPos>();
            ArrayList<BlockPos> b = new ArrayList<BlockPos>();
            boolean hasReached = false;
            for (BlockPos p : this.positions) {
                if (p.equals((Object)pos)) {
                    hasReached = true;
                    continue;
                }
                if (hasReached) {
                    b.add(p);
                    continue;
                }
                a.add(p);
            }
            this.loop = false;
            PathConnection conA = new PathConnection(this.subCache);
            PathConnection conB = new PathConnection(this.subCache);
            conA.positions.addAll(a);
            conB.positions.addAll(b);
            this.positions.clear();
            this.subCache.destroyConnection(this);
            this.subCache.addConnection(conA);
            this.subCache.addConnection(conB);
        }
    }

    public boolean addMarker(BlockPos from, BlockPos toAdd) {
        if (this.loop) {
            return false;
        }
        boolean contains = this.positions.contains(toAdd);
        if (this.positions.getFirst().equals((Object)from)) {
            if (this.positions.getLast().equals((Object)toAdd)) {
                this.loop = true;
            } else if (!contains) {
                this.positions.addFirst(toAdd);
            } else {
                return false;
            }
            this.subCache.refreshConnection(this);
            return true;
        }
        if (this.positions.getLast().equals((Object)from)) {
            if (this.positions.getFirst().equals((Object)toAdd)) {
                this.loop = true;
                return true;
            }
            if (contains) {
                return false;
            }
            this.positions.addLast(toAdd);
            this.subCache.refreshConnection(this);
            return true;
        }
        return false;
    }

    public boolean canAddMarker(BlockPos from, BlockPos toAdd) {
        if (this.loop) {
            return false;
        }
        boolean contains = this.positions.contains(toAdd);
        if (this.positions.getFirst().equals((Object)from)) {
            if (contains) {
                return this.positions.getLast().equals((Object)toAdd);
            }
            return true;
        }
        if (this.positions.getLast().equals((Object)from)) {
            if (contains) {
                return this.positions.getLast().equals((Object)toAdd);
            }
            return true;
        }
        return false;
    }

    public boolean mergeWith(PathConnection conTo, BlockPos from, BlockPos to) {
        if (this.loop || conTo.loop) {
            return false;
        }
        if (conTo == this) {
            if (this.positions.size() <= 2) {
                return false;
            }
            if (this.positions.getFirst().equals((Object)to) && this.positions.getLast().equals((Object)from)) {
                this.loop = true;
                this.subCache.refreshConnection(this);
                return true;
            }
            return false;
        }
        if (this.positions.getLast().equals((Object)from) && conTo.positions.getFirst().equals((Object)to)) {
            this.subCache.destroyConnection(conTo);
            this.positions.addAll(conTo.positions);
            this.subCache.refreshConnection(this);
            return true;
        }
        return false;
    }

    public boolean canMergeWith(PathConnection conTo, BlockPos from, BlockPos to) {
        if (this.loop || conTo.loop) {
            return false;
        }
        if (conTo == this) {
            return this.positions.size() > 2 && this.positions.getFirst().equals((Object)to) && this.positions.getLast().equals((Object)from);
        }
        return this.positions.getLast().equals((Object)from) && conTo.positions.getFirst().equals((Object)to);
    }

    public ImmutableList<BlockPos> getMarkerPositions() {
        if (this.loop && this.positions.size() > 0) {
            ImmutableList.Builder list = ImmutableList.builder();
            list.addAll(this.positions);
            list.add((Object)this.positions.getFirst());
            return list.build();
        }
        return ImmutableList.copyOf(this.positions);
    }

    public void reverseDirection() {
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        while (!this.positions.isEmpty()) {
            list.addFirst(this.positions.removeFirst());
        }
        this.positions.clear();
        this.positions.addAll(list);
        this.subCache.refreshConnection(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInWorld() {
        BlockPos last = null;
        for (BlockPos p : this.positions) {
            if (last == null) {
                last = p;
                continue;
            }
            PathConnection.renderLaser(VecUtil.add(VEC_HALF, (Vec3i)last), VecUtil.add(VEC_HALF, (Vec3i)p));
            last = p;
        }
        if (this.loop) {
            BlockPos from = this.positions.getLast();
            BlockPos to = this.positions.getFirst();
            PathConnection.renderLaser(VecUtil.add(VEC_HALF, (Vec3i)from), VecUtil.add(VEC_HALF, (Vec3i)to));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderLaser(Vec3d from, Vec3d to) {
        Vec3d one = PathConnection.offset(from, to);
        Vec3d two = PathConnection.offset(to, from);
        LaserData_BC8 data = new LaserData_BC8(BuildCraftLaserManager.MARKER_PATH_CONNECTED, one, two, 0.06230529595015576);
        LaserRenderer_BC8.renderLaserStatic(data);
    }

    @SideOnly(value=Side.CLIENT)
    private static Vec3d offset(Vec3d from, Vec3d to) {
        Vec3d dir = to.func_178788_d(from).func_72432_b();
        return from.func_178787_e(VecUtil.scale(dir, 0.125));
    }
}

