/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.item;

import buildcraft.core.marker.PathSubCache;
import buildcraft.core.marker.VolumeSubCache;
import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.VecUtil;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemMarkerConnector
extends ItemBC_Neptune {
    private static final ResourceLocation ADVANCEMENT_VOLUME_MARKER = new ResourceLocation("buildcraftcore:markers");
    private static final ResourceLocation ADVANCEMENT_PATH_MARKER = new ResourceLocation("buildcraftcore:path_markers");

    public ItemMarkerConnector(String id) {
        super(id);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            for (MarkerCache<?> cache : MarkerCache.CACHES) {
                if (!ItemMarkerConnector.interactCache(cache.getSubCache(world), player)) continue;
                player.func_184609_a(hand);
                break;
            }
        }
        return new ActionResult(this.onItemRightClickVolumeBoxes(world, player), (Object)player.func_184586_b(hand));
    }

    private static <S extends MarkerSubCache<?>> boolean interactCache(S cache, EntityPlayer player) {
        MarkerLineInteraction best = null;
        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d playerLook = player.func_70040_Z();
        for (BlockPos marker : cache.getAllMarkers()) {
            ImmutableList<BlockPos> possibles = cache.getValidConnections(marker);
            for (BlockPos possible : possibles) {
                MarkerLineInteraction interaction = new MarkerLineInteraction(marker, possible, playerPos, playerLook);
                if (!interaction.didInteract()) continue;
                best = interaction.getBetter(best);
            }
        }
        if (best == null) {
            return false;
        }
        if (cache.tryConnect(best.marker1, best.marker2) || cache.tryConnect(best.marker2, best.marker1)) {
            if (cache instanceof VolumeSubCache) {
                AdvancementUtil.unlockAdvancement(player, ADVANCEMENT_VOLUME_MARKER);
            } else if (cache instanceof PathSubCache) {
                AdvancementUtil.unlockAdvancement(player, ADVANCEMENT_PATH_MARKER);
            }
            return true;
        }
        return false;
    }

    public static boolean doesInteract(BlockPos a, BlockPos b, EntityPlayer player) {
        return new MarkerLineInteraction(a, b, player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_70040_Z()).didInteract();
    }

    /*
     * Enabled aggressive block sorting
     */
    private EnumActionResult onItemRightClickVolumeBoxes(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        WorldSavedDataVolumeBoxes volumeBoxes = WorldSavedDataVolumeBoxes.get(world);
        VolumeBox currentEditing = volumeBoxes.getCurrentEditing(player);
        Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d end = start.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
        Pair<VolumeBox, EnumAddonSlot> selectingVolumeBoxAndSlot = EnumAddonSlot.getSelectingVolumeBoxAndSlot(player, volumeBoxes.volumeBoxes);
        VolumeBox addonVolumeBox = (VolumeBox)selectingVolumeBoxAndSlot.getLeft();
        EnumAddonSlot addonSlot = (EnumAddonSlot)((Object)selectingVolumeBoxAndSlot.getRight());
        if (addonVolumeBox != null && addonSlot != null) {
            if (!addonVolumeBox.addons.containsKey((Object)addonSlot)) return EnumActionResult.FAIL;
            if (!addonVolumeBox.getLockTargetsStream().noneMatch(target -> target instanceof Lock.Target.TargetAddon && ((Lock.Target.TargetAddon)target).slot == addonSlot)) return EnumActionResult.FAIL;
            if (player.func_70093_af()) {
                addonVolumeBox.addons.get((Object)addonSlot).onRemoved();
                addonVolumeBox.addons.remove((Object)addonSlot);
                volumeBoxes.func_76185_a();
                return EnumActionResult.FAIL;
            }
            addonVolumeBox.addons.get((Object)addonSlot).onPlayerRightClick(player);
            volumeBoxes.func_76185_a();
            return EnumActionResult.FAIL;
        }
        if (player.func_70093_af()) {
            VolumeBox volumeBox;
            if (currentEditing != null) {
                currentEditing.cancelEditing();
                volumeBoxes.func_76185_a();
                return EnumActionResult.SUCCESS;
            }
            Iterator<VolumeBox> iterator = volumeBoxes.volumeBoxes.iterator();
            do {
                if (!iterator.hasNext()) return EnumActionResult.FAIL;
                volumeBox = iterator.next();
            } while (volumeBox.box.getBoundingBox().func_72327_a(start, end) == null);
            if (!volumeBox.getLockTargetsStream().noneMatch(Lock.Target.TargetResize.class::isInstance)) return EnumActionResult.FAIL;
            volumeBox.addons.values().forEach(Addon::onRemoved);
            iterator.remove();
            volumeBoxes.func_76185_a();
            return EnumActionResult.SUCCESS;
        }
        if (currentEditing != null) {
            currentEditing.confirmEditing();
            volumeBoxes.func_76185_a();
            return EnumActionResult.SUCCESS;
        }
        VolumeBox bestVolumeBox = null;
        double bestDist = Double.MAX_VALUE;
        BlockPos editing = null;
        for (VolumeBox volumeBox : volumeBoxes.volumeBoxes.stream().filter(box -> box.getLockTargetsStream().noneMatch(Lock.Target.TargetResize.class::isInstance)).collect(Collectors.toList())) {
            for (BlockPos p : PositionUtil.getCorners(volumeBox.box.min(), volumeBox.box.max())) {
                double dist;
                RayTraceResult ray = new AxisAlignedBB(p).func_72327_a(start, end);
                if (ray == null || !(bestDist > (dist = ray.field_72307_f.func_72438_d(start)))) continue;
                bestDist = dist;
                bestVolumeBox = volumeBox;
                editing = p;
            }
        }
        if (bestVolumeBox == null) return EnumActionResult.FAIL;
        bestVolumeBox.setPlayer(player);
        BlockPos min = bestVolumeBox.box.min();
        BlockPos max = bestVolumeBox.box.max();
        BlockPos held = min;
        if (editing.func_177958_n() == min.func_177958_n()) {
            held = VecUtil.replaceValue((Vec3i)held, EnumFacing.Axis.X, max.func_177958_n());
        }
        if (editing.func_177956_o() == min.func_177956_o()) {
            held = VecUtil.replaceValue((Vec3i)held, EnumFacing.Axis.Y, max.func_177956_o());
        }
        if (editing.func_177952_p() == min.func_177952_p()) {
            held = VecUtil.replaceValue((Vec3i)held, EnumFacing.Axis.Z, max.func_177952_p());
        }
        bestVolumeBox.setHeldDistOldMinOldMax(held, Math.max(1.5, bestDist + 0.5), bestVolumeBox.box.min(), bestVolumeBox.box.max());
        volumeBoxes.func_76185_a();
        return EnumActionResult.SUCCESS;
    }

    private static class MarkerLineInteraction {
        public final BlockPos marker1;
        public final BlockPos marker2;
        public final double distToPoint;
        public final double distToLine;

        public MarkerLineInteraction(BlockPos marker1, BlockPos marker2, Vec3d playerPos, Vec3d playerEndPos) {
            this.marker1 = marker1;
            this.marker2 = marker2;
            PositionUtil.LineSkewResult interactionPoint = PositionUtil.findLineSkewPoint(new PositionUtil.Line(VecUtil.convertCenter((Vec3i)marker1), VecUtil.convertCenter((Vec3i)marker2)), playerPos, playerEndPos);
            this.distToPoint = interactionPoint.closestPos.func_72438_d(playerPos);
            this.distToLine = interactionPoint.distFromLine;
        }

        public boolean didInteract() {
            return this.distToPoint <= 3.0 && this.distToLine < 0.3;
        }

        public MarkerLineInteraction getBetter(MarkerLineInteraction other) {
            if (other == null) {
                return this;
            }
            if (other.marker1 == this.marker2 && other.marker2 == this.marker1) {
                return other;
            }
            if (other.distToLine < this.distToLine) {
                return other;
            }
            if (other.distToLine > this.distToLine) {
                return this;
            }
            if (other.distToPoint < this.distToPoint) {
                return other;
            }
            return this;
        }
    }
}

