/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport;

import buildcraft.api.transport.EnumWirePart;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class WireNode {
    public final BlockPos pos;
    public final EnumWirePart part;
    private final int hash;

    public WireNode(BlockPos pos, EnumWirePart part) {
        this.pos = pos;
        this.part = part;
        this.hash = pos.hashCode() * 31 + part.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WireNode other = (WireNode)obj;
        return this.part == other.part && this.pos.equals((Object)other.pos);
    }

    public String toString() {
        return "(" + this.pos.func_177958_n() + ", " + this.pos.func_177956_o() + ", " + this.pos.func_177952_p() + ", " + (Object)((Object)this.part) + ")";
    }

    public WireNode offset(EnumFacing face) {
        int nx = (this.part.x == EnumFacing.AxisDirection.POSITIVE ? 1 : 0) + face.func_82601_c();
        int ny = (this.part.y == EnumFacing.AxisDirection.POSITIVE ? 1 : 0) + face.func_96559_d();
        int nz = (this.part.z == EnumFacing.AxisDirection.POSITIVE ? 1 : 0) + face.func_82599_e();
        EnumWirePart nPart = EnumWirePart.get(nx, ny, nz);
        if (nx < 0 || ny < 0 || nz < 0 || nx > 1 || ny > 1 || nz > 1) {
            return new WireNode(this.pos.func_177972_a(face), nPart);
        }
        return new WireNode(this.pos, nPart);
    }

    public Map<EnumFacing, WireNode> getAllPossibleConnections() {
        EnumMap<EnumFacing, WireNode> map = new EnumMap<EnumFacing, WireNode>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            map.put(face, this.offset(face));
        }
        return map;
    }
}

