/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StringUtilBC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidUtilBC {
    public static void pushFluidAround(IBlockAccess world, BlockPos pos, Tank tank) {
        FluidStack actuallyDrained;
        FluidStack potential = tank.drain(tank.getFluidAmount(), false);
        int drained = 0;
        if (potential == null || potential.amount <= 0) {
            return;
        }
        FluidStack working = potential.copy();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int used;
            IFluidHandler handler;
            if (potential.amount <= 0) break;
            TileEntity target = world.func_175625_s(pos.func_177972_a(side));
            if (target == null || (handler = (IFluidHandler)target.getCapability(CapUtil.CAP_FLUIDS, side.func_176734_d())) == null || (used = handler.fill(potential.copy(), true)) <= 0) continue;
            drained += used;
            potential.amount -= used;
        }
        if (drained > 0 && ((actuallyDrained = tank.drain(drained, true)) == null || actuallyDrained.amount != drained)) {
            String strWorking = StringUtilBC.fluidToString(working);
            String strActual = StringUtilBC.fluidToString(actuallyDrained);
            throw new IllegalStateException("Bad tank! Could drain " + strWorking + " but only drained " + strActual + "( tank " + tank.getClass() + ")");
        }
    }

    public static List<FluidStack> mergeSameFluids(List<FluidStack> fluids) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        fluids.forEach(toAdd -> {
            boolean found = false;
            for (FluidStack stack : stacks) {
                if (!stack.isFluidEqual(toAdd)) continue;
                stack.amount += toAdd.amount;
                found = true;
            }
            if (!found) {
                stacks.add(toAdd.copy());
            }
        });
        return stacks;
    }

    public static boolean areFluidStackEqual(FluidStack a, FluidStack b) {
        return a == null && b == null || a != null && a.isFluidEqual(b) && a.amount == b.amount;
    }

    public static boolean areFluidsEqual(Fluid a, Fluid b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.getName().equals(b.getName());
    }

    @Nullable
    public static FluidStack move(IFluidHandler from, IFluidHandler to) {
        return FluidUtilBC.move(from, to, Integer.MAX_VALUE);
    }

    @Nullable
    public static FluidStack move(IFluidHandler from, IFluidHandler to, int max) {
        FluidStack toDrainPotential;
        if (from == null || to == null) {
            return null;
        }
        if (from instanceof IFluidHandlerAdv) {
            IFluidFilter filter = f -> to.fill(f, false) > 0;
            toDrainPotential = ((IFluidHandlerAdv)from).drain(filter, max, false);
        } else {
            toDrainPotential = from.drain(max, false);
        }
        int accepted = to.fill(toDrainPotential, false);
        if (accepted <= 0) {
            return null;
        }
        FluidStack toDrain = new FluidStack(toDrainPotential, accepted);
        FluidStack drained = from.drain(toDrain, true);
        if (!toDrain.isFluidEqual(drained) || toDrain.amount != drained.amount) {
            String detail = "(To Drain = " + StringUtilBC.fluidToString(toDrain);
            detail = detail + ",\nactually drained = " + StringUtilBC.fluidToString(drained) + ")";
            detail = detail + ",\nIFluidHandler (from) = " + from.getClass() + "(" + from + ")";
            detail = detail + ",\nIFluidHandler (to) = " + to.getClass() + "(" + to + ")";
            throw new IllegalStateException("Drained fluid did not equal expected fluid!\n" + detail);
        }
        int actuallyAccepted = to.fill(drained, true);
        if (actuallyAccepted != accepted) {
            String detail = "(actually accepted = " + actuallyAccepted + ", accepted = " + accepted + ")";
            throw new IllegalStateException("Mismatched IFluidHandler implementations!\n" + detail);
        }
        return new FluidStack(drained, accepted);
    }

    public static boolean onTankActivated(EntityPlayer player, BlockPos pos, EnumHand hand, IFluidHandler fluidHandler) {
        IFluidHandlerItem flItem;
        boolean single;
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b()) {
            return false;
        }
        boolean replace = !player.field_71075_bZ.field_75098_d;
        boolean bl = single = held.func_190916_E() == 1;
        if (replace && single) {
            flItem = FluidUtil.getFluidHandler((ItemStack)held);
        } else {
            ItemStack copy = held.func_77946_l();
            copy.func_190920_e(1);
            flItem = FluidUtil.getFluidHandler((ItemStack)copy);
        }
        if (flItem == null) {
            return false;
        }
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return true;
        }
        boolean changed = true;
        FluidStack moved = FluidUtilBC.move((IFluidHandler)flItem, fluidHandler);
        if (moved != null) {
            SoundUtil.playBucketEmpty(world, pos, moved);
        } else {
            moved = FluidUtilBC.move(fluidHandler, (IFluidHandler)flItem);
            if (moved != null) {
                SoundUtil.playBucketFill(world, pos, moved);
            } else {
                changed = false;
            }
        }
        if (changed && replace) {
            if (single) {
                player.func_184611_a(hand, flItem.getContainer());
            } else {
                held.func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)flItem.getContainer());
            }
            player.field_71069_bz.func_75142_b();
        }
        return true;
    }
}

