/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.json.JsonGuiIterator;
import buildcraft.lib.json.JsonVariableObject;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class JsonGuiElement
extends JsonVariableObject {
    public final String name;
    public final String fullName;
    public final Map<String, String> properties = new LinkedHashMap<String, String>();
    @Nullable
    public final JsonGuiIterator iterator;
    public final FunctionContext context;
    public final JsonObject json;
    private final Map<String, JsonGuiElement> types;

    private JsonGuiElement(String name, String fullName, FunctionContext context, JsonObject json, JsonGuiIterator.ResolvedIterator iter) {
        this.name = name;
        this.fullName = fullName;
        this.context = new FunctionContext(context);
        iter.putProperties(context, this.properties);
        this.json = json;
        this.iterator = null;
        this.types = new LinkedHashMap<String, JsonGuiElement>();
        if (json.has("variables") && json.get("variables").isJsonObject()) {
            this.putVariables(json.getAsJsonObject("variables"), this.context);
        }
        this.finaliseVariables();
    }

    public JsonGuiElement(JsonObject json, String name, String fullName, Map<String, JsonGuiElement> typeLookup, FunctionContext context) {
        try {
            JsonGuiElement parent;
            this.json = json;
            this.name = name;
            this.fullName = fullName;
            this.context = new FunctionContext(context);
            this.types = typeLookup;
            String str = JsonUtils.func_151219_a((JsonObject)json, (String)"type", null);
            if (str != null && (parent = typeLookup.get(str)) != null) {
                this.properties.putAll(parent.properties);
            }
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                if ("type".equals(key) && this.properties.containsKey("type")) continue;
                JsonElement value = (JsonElement)entry.getValue();
                this.putProperties(key, value);
            }
            if (json.has("iterator")) {
                this.iterator = new JsonGuiIterator(json.get("iterator"));
            } else {
                this.iterator = null;
                if (json.has("variables") && json.get("variables").isJsonObject()) {
                    this.putVariables(json.getAsJsonObject("variables"), this.context);
                }
            }
            this.finaliseVariables();
        }
        catch (JsonSyntaxException jse) {
            throw new JsonSyntaxException("Failed to read element " + name, (Throwable)jse);
        }
    }

    private void putProperties(String key, JsonElement value) {
        if (value.isJsonPrimitive()) {
            this.properties.put(key, value.getAsString());
        } else if (value.isJsonArray()) {
            JsonArray array = value.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                this.putProperties(key + "[" + i + "]", array.get(i));
            }
        } else if (value.isJsonObject()) {
            JsonObject sub = value.getAsJsonObject();
            for (Map.Entry entry : sub.entrySet()) {
                this.putProperties(key + "." + (String)entry.getKey(), (JsonElement)entry.getValue());
            }
        } else if (value.isJsonNull()) {
            this.properties.put(key, "null");
        }
    }

    public List<JsonGuiElement> iterate(FunctionContext fnCtx) {
        ArrayList<JsonGuiElement> list = new ArrayList<JsonGuiElement>();
        if (this.iterator == null) {
            list.add(this);
        } else {
            JsonGuiIterator jsonGuiIterator = this.iterator;
            jsonGuiIterator.getClass();
            JsonGuiIterator.ResolvedIterator resolvedIterator = new JsonGuiIterator.ResolvedIterator(jsonGuiIterator, fnCtx);
            if (resolvedIterator.start()) {
                do {
                    JsonGuiElement elem = new JsonGuiElement(this.name, this.fullName, this.context, this.json, resolvedIterator);
                    elem.types.putAll(this.types);
                    elem.properties.putAll(this.properties);
                    list.add(elem);
                } while (!resolvedIterator.iterate());
            }
        }
        return list;
    }

    public List<JsonGuiElement> getChildren(String subName) {
        JsonElement chElem = this.json.get(subName);
        if (chElem == null || !chElem.isJsonObject()) {
            return ImmutableList.of();
        }
        JsonObject chObject = chElem.getAsJsonObject();
        ArrayList<JsonGuiElement> list = new ArrayList<JsonGuiElement>();
        for (Map.Entry key : chObject.entrySet()) {
            String chName = (String)key.getKey();
            JsonElement value = (JsonElement)key.getValue();
            list.add(this.getChildElement(chName, value));
        }
        return list;
    }

    public JsonGuiElement getChildElement(String childName, JsonElement elem) {
        JsonElement value = elem;
        if (!value.isJsonObject()) {
            throw new JsonSyntaxException("Expected an object, got " + value);
        }
        JsonObject childObject = value.getAsJsonObject();
        return new JsonGuiElement(childObject, childName, this.fullName + "." + childName, this.types, this.context);
    }

    public String toString() {
        return "JsonGuiElement[ " + this.properties + " ]";
    }

    public void printOut(Consumer<String> logger) {
        Consumer<String> log2 = s -> logger.accept("  " + s);
        logger.accept(this.name + ":");
        for (String key : this.properties.keySet()) {
            log2.accept(key + " = " + this.properties.get(key));
        }
    }
}

