/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import java.util.ArrayList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LaserBoxRenderer {
    private static final double RENDER_SCALE = 0.06230529595015576;

    public static void renderLaserBoxStatic(Box box, LaserData_BC8.LaserType type, boolean center) {
        if (box == null || box.min() == null || box.max() == null) {
            return;
        }
        LaserBoxRenderer.makeLaserBox(box, type, center);
        for (LaserData_BC8 data : box.laserData) {
            LaserRenderer_BC8.renderLaserStatic(data);
        }
    }

    public static void renderLaserBoxDynamic(Box box, LaserData_BC8.LaserType type, BufferBuilder bb, boolean center) {
        if (box == null || box.min() == null || box.max() == null) {
            return;
        }
        LaserBoxRenderer.makeLaserBox(box, type, center);
        for (LaserData_BC8 data : box.laserData) {
            LaserRenderer_BC8.renderLaserDynamic(data, bb);
        }
    }

    private static void makeLaserBox(Box box, LaserData_BC8.LaserType type, boolean center) {
        boolean renderY;
        boolean renderX;
        if (box.min().equals((Object)box.lastMin) && box.max().equals((Object)box.lastMax) && box.lastType == type && box.laserData != null) {
            return;
        }
        boolean bl = center ? box.size().func_177958_n() > 1 : (renderX = true);
        boolean bl2 = center ? box.size().func_177956_o() > 1 : (renderY = true);
        boolean renderZ = center ? box.size().func_177952_p() > 1 : true;
        Vec3d min = new Vec3d((Vec3i)box.min()).func_178787_e(center ? VecUtil.VEC_HALF : Vec3d.field_186680_a);
        Vec3d max = new Vec3d((Vec3i)box.max()).func_178787_e(center ? VecUtil.VEC_HALF : VecUtil.VEC_ONE);
        ArrayList<LaserData_BC8> datas = new ArrayList<LaserData_BC8>();
        Vec3d[][][] vecs = new Vec3d[2][2][2];
        vecs[0][0][0] = new Vec3d(min.field_72450_a, min.field_72448_b, min.field_72449_c);
        vecs[1][0][0] = new Vec3d(max.field_72450_a, min.field_72448_b, min.field_72449_c);
        vecs[0][1][0] = new Vec3d(min.field_72450_a, max.field_72448_b, min.field_72449_c);
        vecs[1][1][0] = new Vec3d(max.field_72450_a, max.field_72448_b, min.field_72449_c);
        vecs[0][0][1] = new Vec3d(min.field_72450_a, min.field_72448_b, max.field_72449_c);
        vecs[1][0][1] = new Vec3d(max.field_72450_a, min.field_72448_b, max.field_72449_c);
        vecs[0][1][1] = new Vec3d(min.field_72450_a, max.field_72448_b, max.field_72449_c);
        vecs[1][1][1] = new Vec3d(max.field_72450_a, max.field_72448_b, max.field_72449_c);
        if (renderX) {
            datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][0][0], vecs[1][0][0], EnumFacing.Axis.X));
            if (renderY) {
                datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][1][0], vecs[1][1][0], EnumFacing.Axis.X));
                if (renderZ) {
                    datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][1][1], vecs[1][1][1], EnumFacing.Axis.X));
                }
            }
            if (renderZ) {
                datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][0][1], vecs[1][0][1], EnumFacing.Axis.X));
            }
        }
        if (renderY) {
            datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][0][0], vecs[0][1][0], EnumFacing.Axis.Y));
            if (renderX) {
                datas.add(LaserBoxRenderer.makeLaser(type, vecs[1][0][0], vecs[1][1][0], EnumFacing.Axis.Y));
                if (renderZ) {
                    datas.add(LaserBoxRenderer.makeLaser(type, vecs[1][0][1], vecs[1][1][1], EnumFacing.Axis.Y));
                }
            }
            if (renderZ) {
                datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][0][1], vecs[0][1][1], EnumFacing.Axis.Y));
            }
        }
        if (renderZ) {
            datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][0][0], vecs[0][0][1], EnumFacing.Axis.Z));
            if (renderX) {
                datas.add(LaserBoxRenderer.makeLaser(type, vecs[1][0][0], vecs[1][0][1], EnumFacing.Axis.Z));
                if (renderY) {
                    datas.add(LaserBoxRenderer.makeLaser(type, vecs[1][1][0], vecs[1][1][1], EnumFacing.Axis.Z));
                }
            }
            if (renderY) {
                datas.add(LaserBoxRenderer.makeLaser(type, vecs[0][1][0], vecs[0][1][1], EnumFacing.Axis.Z));
            }
        }
        box.laserData = datas.toArray(new LaserData_BC8[0]);
        box.lastMin = box.min();
        box.lastMax = box.max();
        box.lastType = type;
    }

    private static LaserData_BC8 makeLaser(LaserData_BC8.LaserType type, Vec3d min, Vec3d max, EnumFacing.Axis axis) {
        EnumFacing faceForMin = VecUtil.getFacing(axis, true);
        EnumFacing faceForMax = VecUtil.getFacing(axis, false);
        Vec3d one = min.func_178787_e(new Vec3d(faceForMin.func_176730_m()).func_186678_a(0.0625));
        Vec3d two = max.func_178787_e(new Vec3d(faceForMax.func_176730_m()).func_186678_a(0.0625));
        return new LaserData_BC8(type, one, two, 0.06230529595015576);
    }
}

