/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.json.JsonVariableFaceUV;
import buildcraft.lib.client.model.json.JsonVariableModel;
import buildcraft.lib.client.model.json.VariablePartCuboidBase;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class VariablePartCuboid
extends VariablePartCuboidBase {
    public final Map<EnumFacing, JsonVariableFaceUV> faces = new HashMap<EnumFacing, JsonVariableFaceUV>();

    public VariablePartCuboid(JsonObject obj, FunctionContext fnCtx) {
        super(obj, fnCtx);
        JsonElement elem;
        if (!obj.has("faces")) {
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got nothing");
        }
        String invertDefault = null;
        if (obj.has("invert")) {
            invertDefault = JsonUtil.getAsString(obj.get("invert"));
        }
        String bothSides = null;
        if (obj.has("both_sides")) {
            bothSides = JsonUtil.getAsString(obj.get("both_sides"));
        }
        if (!(elem = obj.get("faces")).isJsonObject()) {
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got '" + elem + "'");
        }
        JsonObject jFaces = elem.getAsJsonObject();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!jFaces.has(face.func_176610_l())) continue;
            JsonElement jFace = jFaces.get(face.func_176610_l());
            if (!jFace.isJsonObject()) {
                throw new JsonSyntaxException("Expected an object, but got " + jFace);
            }
            JsonObject jFaceObj = jFace.getAsJsonObject();
            if (invertDefault != null && !jFaceObj.has("invert")) {
                jFaceObj.addProperty("invert", invertDefault);
            }
            if (bothSides != null && !jFaceObj.has("both_sides")) {
                jFaceObj.addProperty("both_sides", bothSides);
            }
            this.faces.put(face, new JsonVariableFaceUV(jFaceObj, fnCtx));
        }
        if (this.faces.size() == 0) {
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got an empty object " + jFaces);
        }
    }

    @Override
    protected VariablePartCuboidBase.VariableFaceData getFaceData(EnumFacing side, JsonVariableModel.ITextureGetter spriteLookup) {
        JsonVariableFaceUV var = this.faces.get(side);
        if (var == null || !var.visible.evaluate()) {
            return null;
        }
        return var.evaluate(spriteLookup);
    }
}

