/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.node.FormatString;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.pos.GuiRectangle;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public abstract class GuidePart {
    public static final int INDENT_WIDTH = 16;
    public static final int LINE_HEIGHT = 16;
    protected final GuiGuide gui;
    private IFontRenderer fontRenderer;
    protected boolean wasHovered = false;
    protected boolean wasIconHovered = false;
    protected boolean didRender = false;

    public GuidePart(GuiGuide gui) {
        this.gui = gui;
    }

    public IFontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public void setFontRenderer(IFontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
    }

    public boolean wasHovered() {
        return this.wasHovered;
    }

    public void updateScreen() {
    }

    protected void renderTextLine(String text, int x, int y, int colour) {
        this.fontRenderer.drawString(text, x, y + 8 - this.fontRenderer.getFontHeight(text) / 2, colour);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public abstract PagePosition renderIntoArea(int var1, int var2, int var3, int var4, PagePosition var5, int var6);

    public abstract PagePosition handleMouseClick(int var1, int var2, int var3, int var4, PagePosition var5, int var6, int var7, int var8);

    public void handleMouseDragPartial(int startX, int startY, int currentX, int currentY, int button) {
    }

    public void handleMouseDragFinish(int startX, int startY, int endX, int endY, int button) {
    }

    protected PagePosition renderLine(PagePosition current, PageLine line, int x, int y, int width, int height, int pageRenderIndex) {
        this.wasHovered = false;
        this.wasIconHovered = false;
        int allowedWidth = width - 16 * line.indent;
        if (allowedWidth <= 0) {
            throw new IllegalStateException("Was indented too far");
        }
        String toRender = line.text;
        ISimpleDrawable icon = line.startIcon;
        FormatString next = FormatString.split(line.text);
        int neededSpace = this.fontRenderer.getFontHeight(line.text);
        if (icon != null) {
            neededSpace = Math.max(16, neededSpace);
        }
        current = current.guaranteeSpace(neededSpace, height);
        int _x = x + 16 * line.indent;
        if (icon != null && current.page == pageRenderIndex) {
            int iconX = _x - 18;
            int iconY = y + current.pixel - 5;
            GuiRectangle rect = new GuiRectangle(iconX, iconY, 16.0, 16.0);
            if (rect.contains(this.gui.mouse) && line.startIconHovered != null) {
                icon = line.startIconHovered;
            }
            icon.drawAt(iconX, iconY);
        }
        this.didRender = false;
        while (next != null) {
            FormatString[] strings = next.wrap(this.fontRenderer, allowedWidth);
            String text = strings[0].getFormatted();
            boolean render = current.page == pageRenderIndex;
            int _y = y + current.pixel;
            int _w = this.fontRenderer.getStringWidth(text);
            GuiRectangle rect = new GuiRectangle(_x, _y - 2, _w, neededSpace + 3);
            this.wasHovered |= rect.contains(this.gui.mouse);
            if (render) {
                this.didRender = true;
                if (this.wasHovered) {
                    if (line.link) {
                        Gui.func_73734_a((int)(_x - 2), (int)(_y - 2), (int)(_x + _w + 2), (int)(_y + 1 + neededSpace), (int)-2904724);
                    }
                    this.renderTooltip();
                }
                this.fontRenderer.drawString(text, _x, _y, 0);
            }
            next = strings.length == 1 ? null : strings[1];
            current = current.nextLine(this.fontRenderer.getFontHeight(text) + 3, height);
        }
        int additional = 16 - this.fontRenderer.getFontHeight(toRender) - 3;
        current = current.nextLine(additional, height);
        return current;
    }

    protected PagePosition renderLines(Iterable<PageLine> lines, PagePosition part, int x, int y, int width, int height, int index) {
        for (PageLine line : lines) {
            part = this.renderLine(part, line, x, y, width, height, index);
        }
        return part;
    }

    protected PagePosition renderLines(Iterable<PageLine> lines, int x, int y, int width, int height, int index) {
        return this.renderLines(lines, new PagePosition(0, 0), x, y, width, height, index);
    }

    protected void renderTooltip() {
    }

    public static class PagePosition {
        public final int page;
        public final int pixel;

        public PagePosition(int page, int pixel) {
            this.page = page;
            this.pixel = pixel;
        }

        public PagePosition nextLine(int pixelDifference, int maxHeight) {
            int added = this.pixel + pixelDifference;
            if (added >= maxHeight) {
                return this.nextPage();
            }
            return new PagePosition(this.page, added);
        }

        public PagePosition guaranteeSpace(int required, int maxPageHeight) {
            PagePosition next = this.nextLine(required, maxPageHeight);
            if (next.page == this.page) {
                return this;
            }
            return next;
        }

        public PagePosition nextPage() {
            return new PagePosition(this.page + 1, 0);
        }

        public PagePosition newPage() {
            if (this.pixel != 0) {
                return this.nextPage();
            }
            return this;
        }
    }
}

