/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.energy.BCEnergyBlocks;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.energy.BCEnergyEntities;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.energy.BCEnergyItems;
import buildcraft.energy.BCEnergyProxy;
import buildcraft.energy.BCEnergyRecipes;
import buildcraft.energy.BCEnergyWorldGen;
import buildcraft.lib.registry.MigrationManager;
import buildcraft.lib.registry.RegistryConfig;
import buildcraft.lib.registry.TagManager;
import java.util.function.Consumer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="buildcraftenergy", name="BuildCraft Energy", version="7.99.24.2", dependencies="required-after:buildcraftcore@[7.99.24.2]", acceptedMinecraftVersions="[1.12.2]")
public class BCEnergy {
    public static final String MODID = "buildcraftenergy";
    @Mod.Instance(value="buildcraftenergy")
    public static BCEnergy INSTANCE;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        RegistryConfig.useOtherModConfigFor(MODID, "buildcraftcore");
        BCEnergyConfig.preInit();
        BCEnergyEntities.preInit();
        BCEnergyFluids.preInit();
        BCEnergyBlocks.preInit();
        BCEnergyItems.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCEnergyProxy.getProxy());
        BCEnergyProxy.getProxy().fmlPreInit();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        BCEnergyRecipes.init();
        BCEnergyWorldGen.init();
        BCEnergyProxy.getProxy().fmlInit();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        BCEnergyProxy.getProxy().fmlPostInit();
        BCEnergyConfig.validateBiomeNames();
        BCEnergy.registerMigrations();
    }

    private static void registerMigrations() {
        MigrationManager.INSTANCE.addBlockMigration(BCEnergyFluids.crudeOil[0].getBlock(), "fluid_block_oil");
        MigrationManager.INSTANCE.addBlockMigration(BCEnergyFluids.fuelLight[0].getBlock(), "fluid_block_fuel");
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        FluidRegistry.enableUniversalBucket();
        BCEnergy.startBatch();
        BCEnergy.registerTag("item.glob.oil").reg("glob_of_oil").oldReg("glob_oil").locale("globOil").model("glob_oil");
        BCEnergy.registerTag("tile.engine.stone").reg("engine.stone");
        BCEnergy.registerTag("tile.engine.iron").reg("engine.iron");
        BCEnergy.registerTag("tile.spring.oil").reg("spring.oil");
        BCEnergy.endBatch(TagManager.prependTags("buildcraftenergy:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION).andThen(TagManager.setTab("buildcraft.main")));
    }
}

