vec2 dofOffsets[60] = vec2[60](
	vec2( 0.0    ,  0.25  ),
	vec2(-0.2165 ,  0.125 ),
	vec2(-0.2165 , -0.125 ),
	vec2( 0      , -0.25  ),
	vec2( 0.2165 , -0.125 ),
	vec2( 0.2165 ,  0.125 ),
	vec2( 0      ,  0.5   ),
	vec2(-0.25   ,  0.433 ),
	vec2(-0.433  ,  0.25  ),
	vec2(-0.5    ,  0     ),
	vec2(-0.433  , -0.25  ),
	vec2(-0.25   , -0.433 ),
	vec2( 0      , -0.5   ),
	vec2( 0.25   , -0.433 ),
	vec2( 0.433  , -0.2   ),
	vec2( 0.5    ,  0     ),
	vec2( 0.433  ,  0.25  ),
	vec2( 0.25   ,  0.433 ),
	vec2( 0      ,  0.75  ),
	vec2(-0.2565 ,  0.7048),
	vec2(-0.4821 ,  0.5745),
	vec2(-0.51295,  0.375 ),
	vec2(-0.7386 ,  0.1302),
	vec2(-0.7386 , -0.1302),
	vec2(-0.51295, -0.375 ),
	vec2(-0.4821 , -0.5745),
	vec2(-0.2565 , -0.7048),
	vec2(-0      , -0.75  ),
	vec2( 0.2565 , -0.7048),
	vec2( 0.4821 , -0.5745),
	vec2( 0.51295, -0.375 ),
	vec2( 0.7386 , -0.1302),
	vec2( 0.7386 ,  0.1302),
	vec2( 0.51295,  0.375 ),
	vec2( 0.4821 ,  0.5745),
	vec2( 0.2565 ,  0.7048),
	vec2( 0      ,  1     ),
	vec2(-0.2588 ,  0.9659),
	vec2(-0.5    ,  0.866 ),
	vec2(-0.7071 ,  0.7071),
	vec2(-0.866  ,  0.5   ),
	vec2(-0.9659 ,  0.2588),
	vec2(-1      ,  0     ),
	vec2(-0.9659 , -0.2588),
	vec2(-0.866  , -0.5   ),
	vec2(-0.7071 , -0.7071),
	vec2(-0.5    , -0.866 ),
	vec2(-0.2588 , -0.9659),
	vec2(-0      , -1     ),
	vec2( 0.2588 , -0.9659),
	vec2( 0.5    , -0.866 ),
	vec2( 0.7071 , -0.7071),
	vec2( 0.866  , -0.5   ),
	vec2( 0.9659 , -0.2588),
	vec2( 1      ,  0     ),
	vec2( 0.9659 ,  0.2588),
	vec2( 0.866  ,  0.5   ),
	vec2( 0.7071 ,  0.7071),
	vec2( 0.5    ,  0.8660),
	vec2( 0.2588 ,  0.9659)
);

vec2 blackoutlineoffset[24] = vec2[24](
	vec2(-2.0,  2.0),
	vec2(-1.0,  2.0),
	vec2( 0.0,  2.0),
	vec2( 1.0,  2.0),
	vec2( 2.0,  2.0),
	vec2(-2.0,  1.0),
	vec2(-1.0,  1.0),
	vec2( 0.0,  1.0),
	vec2( 1.0,  1.0),
	vec2( 2.0,  1.0),
	vec2(-2.0,  0.0),
	vec2(-1.0,  0.0),
	vec2( 1.0,  0.0),
	vec2( 2.0,  0.0),
	vec2(-2.0, -1.0),
	vec2(-1.0, -1.0),
	vec2( 0.0, -1.0),
	vec2( 1.0, -1.0),
	vec2( 2.0, -1.0),
	vec2(-2.0, -2.0),
	vec2(-1.0, -2.0),
	vec2( 0.0, -2.0),
	vec2( 1.0, -2.0),
	vec2( 2.0, -2.0)
);

vec3 DepthOfField(vec3 color){
	vec3 dof = vec3(0.0);
	
	float z = texture2D(depthtex1, texCoord.st).r;
	#ifdef BLACK_OUTLINE
	float ph = 1.0 / 1080.0;
	float pw = cph / aspectRatio;
	for(int i = 0; i < 24; i++){
		vec2 offset = vec2(pw, ph) * blackoutlineoffset[i];
		z = min(z, texture2D(depthtex1, texCoord + offset).r);
	}
	#endif
	float hand = float(z < 0.56);
	
	float coc = max(abs(z - centerDepthSmooth) * DOF_STRENGTH - 0.0001, 0.0);
	coc = coc / sqrt(coc * coc + 0.1);
	
	if(coc * 0.015 > 1.0 / max(viewWidth, viewHeight) && hand < 0.5){
		for(int i = 0; i < 60; i++) {
			vec2 offset = dofOffsets[i] * coc * 0.0085 * vec2(1.0, aspectRatio);
			float lod = log2(viewHeight * aspectRatio / 320.0) * coc;
			dof += texture2DLod(colortex0, texCoord + offset, lod).rgb;
		}
		dof /= 60.0;
	}
	else dof = color;
	return dof;
}