float weight[7] = float[7](1.0, 6.0, 15.0, 20.0, 15.0, 6.0, 1.0);

vec3 BloomTile(float lod, vec2 offset){
	vec3 bloom = vec3(0.0), temp = vec3(0.0);
	float scale = pow(2.0, lod);
	vec2 coord = (texCoord - offset) * scale;
	float padding = 0.005 * scale;

	if(coord.x > -padding && coord.x < 1.0 + padding &&
	   coord.y > -padding && coord.y < 1.0 + padding){
		for(int i = -3; i <= 3; i++) {
			for(int j = -3; j <= 3; j++) {
				float wg = weight[i + 3] * weight[j + 3];
				vec2 pixelOffset = vec2(i * pw, j * ph);
				vec2 bloomCoord = (texCoord - offset + pixelOffset) * scale;
				bloom += texture2D(colortex0, bloomCoord).rgb * wg;
			}
		}
		bloom /= 4096.0;
	}

	return pow(bloom / 128.0, vec3(0.25));
}