vec3 GetBloomTile(float lod, vec2 coord, vec2 offset){
	vec3 bloom = texture2D(colortex1, coord / pow(2.0, lod) + offset).rgb;
	bloom *= bloom; bloom *= bloom;
	return bloom * 128.0;
}

void Bloom(inout vec3 color, vec2 coord){
	vec3 blur1 = GetBloomTile(2.0, coord, vec2(0.0      , 0.0   ));
	vec3 blur2 = GetBloomTile(3.0, coord, vec2(0.0      , 0.26  ));
	vec3 blur3 = GetBloomTile(4.0, coord, vec2(0.135    , 0.26  ));
	vec3 blur4 = GetBloomTile(5.0, coord, vec2(0.2075   , 0.26  ));
	vec3 blur5 = GetBloomTile(6.0, coord, vec2(0.135    , 0.3325));
	vec3 blur6 = GetBloomTile(7.0, coord, vec2(0.160625 , 0.3325));
	vec3 blur7 = GetBloomTile(8.0, coord, vec2(0.1784375, 0.3325));
	
	#ifdef DIRTY_LENS
	float newAspectRatio = 1.777777777777778 / aspectRatio;
	vec2 scale = vec2(max(newAspectRatio, 1.0), max(1.0 / newAspectRatio, 1.0));
	float dirt = texture2D(depthtex2, (coord - 0.5) / scale + 0.5).r;
	dirt *= length(blur6 / (1.0 + blur6));
	blur3 *= dirt * 0.5 + 1.0;
	blur4 *= dirt * 1.0 + 1.0;
	blur5 *= dirt * 2.0 + 1.0;
	blur6 *= dirt * 4.0 + 1.0;
	blur7 *= dirt * 8.0 + 1.0;
	#endif

	vec3 blur = (blur1 + blur2 + blur3 + blur4 + blur5 + blur6 + blur7) * 0.14;
	
	color = mix(color, blur, 0.18 * BLOOM_STRENGTH);
}