/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import java.util.LinkedList;

public class GuiTreeElement
extends GuiScrollElement {
    private LinkedList<TreeNode> rootElements = new LinkedList();
    private int nodeSpacing = 1;

    public GuiTreeElement() {
    }

    public GuiTreeElement(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiTreeElement(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
        this.setAllowedScrollAxes(true, true);
        this.setStandardScrollBehavior();
        this.useAbsoluteElementSize(true);
        this.getVerticalScrollBar().setHidden(true);
        this.defaultInsets.bottom = this.maxYPos() - this.horizontalScrollBar.yPos();
    }

    public LinkedList<TreeNode> getRootElements() {
        return this.rootElements;
    }

    public GuiTreeElement setNodeSpacing(int nodeSpacing) {
        this.nodeSpacing = nodeSpacing;
        return this;
    }

    public void updateTree() {
        this.rootElements.forEach(TreeNode::updateNode);
    }

    public TreeNode addRootNode(MGuiElementBase element) {
        TreeNode node = new TreeNode(element, this);
        this.rootElements.add(node);
        this.addElement(element);
        this.updateTree();
        return node;
    }

    public void removeRootNode(TreeNode node) {
        if (this.rootElements.contains(node)) {
            this.rootElements.remove(node);
            this.removeElement(node.element);
        }
    }

    @Override
    public void updateScrollElement() {
        int lastPos = this.getInsetRect().y;
        for (MGuiElementBase element : this.scrollingElements) {
            if (!element.isEnabled() || element == this.backgroundElement) continue;
            element.setYPos(lastPos);
            lastPos += this.elementYSize(element) + this.listSpacing;
        }
        super.updateScrollElement();
    }

    public static class TreeNode {
        public MGuiElementBase element;
        private GuiTreeElement guiElement;
        public LinkedList<TreeNode> branches = new LinkedList();
        public boolean extended = false;

        public TreeNode(MGuiElementBase element, GuiTreeElement guiElement) {
            this.element = element;
            this.guiElement = guiElement;
            this.element.reportYSizeChange = true;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public void setExtended(boolean extended) {
            this.setExtended(extended, true);
        }

        public void setExtended(boolean extended, boolean updateTree) {
            this.extended = extended;
            this.updateNode();
            if (updateTree) {
                this.guiElement.updateTree();
            }
            this.element.ySizeChanged(this.element);
        }

        public TreeNode addSubNode(MGuiElementBase element) {
            TreeNode node = new TreeNode(element, this.guiElement);
            this.branches.add(node);
            this.element.addChild(element);
            this.updateNode();
            this.guiElement.updateTree();
            return node;
        }

        public void removeNode(TreeNode node) {
            this.branches.remove(node);
            this.element.removeChild(node.element);
        }

        public void updateNode() {
            int yPos = this.element.maxYPos() + this.guiElement.nodeSpacing;
            for (TreeNode node : this.branches) {
                MGuiElementBase nodeElement = node.element;
                nodeElement.setEnabled(this.extended);
                nodeElement.setYPos(yPos);
                yPos = yPos + nodeElement.getEnclosingRect().height + this.guiElement.nodeSpacing;
            }
            this.branches.forEach(TreeNode::updateNode);
        }

        public GuiButton addDefaultExtendButton(int xOffset, int yOffset, int xSize, int ySize) {
            GuiButton button = new GuiButton();
            button.setTrim(false).setInsets(0, 0, 0, 0);
            button.setDisplaySupplier(() -> this.extended ? "\u25bc" : "\u25b6");
            button.setTextColour(0);
            button.setListener(() -> this.setExtended(!this.extended));
            ((GuiButton)button.setSize(xSize, ySize)).setRelPos(this.element, xOffset, yOffset);
            button.setEnabledCallback(() -> !this.branches.isEmpty());
            this.element.addChild(button);
            return button;
        }
    }
}

