/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\u001a!\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u00020\u000b\"\u00020\u0002\u00a2\u0006\u0002\u0010\f\u001a&\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\t\u001a\u0015\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0004\" \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"brightnessComponents", "", "", "getBrightnessComponents", "()Ljava/util/List;", "setBrightnessComponents", "(Ljava/util/List;)V", "brSum", "multiplier", "", "brightness", "", "(Ljava/lang/Float;[I)I", "brWeighted", "br1", "weight1", "br2", "weight2", "brMul", "f", "colorMul", "BetterFoliage-MC1.12"})
@JvmName(name="PixelFormat")
public final class PixelFormat {
    @NotNull
    private static List<Integer> brightnessComponents = CollectionsKt.listOf((Object[])new Integer[]{20, 4});

    @NotNull
    public static final List<Integer> getBrightnessComponents() {
        return brightnessComponents;
    }

    public static final void setBrightnessComponents(@NotNull List<Integer> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        brightnessComponents = list;
    }

    public static final int brMul(int $receiver, float f) {
        int weight = (int)(f * 256.0f);
        int result = 0;
        Iterable $receiver$iv = brightnessComponents;
        for (Object element$iv : $receiver$iv) {
            int shift = ((Number)element$iv).intValue();
            int raw = $receiver >> shift & 0xF;
            int weighted = raw * weight / 256;
            result |= weighted << shift;
        }
        return result;
    }

    public static final int colorMul(int $receiver, float f) {
        int weight = (int)(f * 256.0f);
        int red = ($receiver >> 16 & 0xFF) * weight / 256;
        int green = ($receiver >> 8 & 0xFF) * weight / 256;
        int blue = ($receiver & 0xFF) * weight / 256;
        return red << 16 | green << 8 | blue;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brSum(@Nullable Float multiplier, int ... brightness) {
        int idx;
        Intrinsics.checkParameterIsNotNull((Object)brightness, (String)"brightness");
        int size$iv = brightnessComponents.size();
        Integer[] result$iv = new Integer[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            Integer n3;
            void i$iv;
            void var7_17 = i$iv;
            void var20_15 = i$iv++;
            Integer[] integerArray = result$iv;
            integerArray[var20_15] = n3 = Integer.valueOf(0);
        }
        Integer[] sum = result$iv;
        Iterable $receiver$iv = brightnessComponents;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n4 = index$iv++;
            int it = ((Number)item$iv).intValue();
            idx = n4;
            int[] $receiver$iv2 = brightness;
            int n5 = $receiver$iv2.length;
            for (int i = 0; i < n5; ++i) {
                void shift;
                int element$iv;
                int br = element$iv = $receiver$iv2[i];
                int comp = br >> shift & 0xF;
                int n6 = idx;
                sum[n6] = sum[n6] + comp;
            }
        }
        int result = 0;
        Iterable $receiver$iv3 = brightnessComponents;
        int index$iv2 = 0;
        for (Object item$iv : $receiver$iv3) {
            void shift;
            int n7 = index$iv2++;
            idx = ((Number)item$iv).intValue();
            int idx2 = n7;
            int comp = multiplier == null ? sum[idx2] << shift : (int)((float)sum[idx2].intValue() * multiplier.floatValue()) << shift;
            result |= comp;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brWeighted(int br1, float weight1, int br2, float weight2) {
        int w1int = (int)(weight1 * 256.0f + 0.5f);
        int w2int = (int)(weight2 * 256.0f + 0.5f);
        int result = 0;
        Iterable $receiver$iv = brightnessComponents;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void shift;
            int n = index$iv++;
            int n2 = ((Number)item$iv).intValue();
            int idx = n;
            int comp1 = br1 >> shift & 0xF;
            int comp2 = br2 >> shift & 0xF;
            int compWeighted = (comp1 * w1int + comp2 * w2int) / 256;
            result |= (compWeighted & 0xF) << shift;
        }
        return result;
    }
}

