/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import its_meow.betteranimalsplus.common.entity.EntityAnimalWithTypes;
import its_meow.betteranimalsplus.common.entity.EntityJellyfish;
import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.common.entity.miniboss.hirschgeist.EntityHirschgeist;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityBobbitWorm
extends EntityAnimalWithTypes {
    protected static final DataParameter<Integer> ATTACK_STATE = EntityDataManager.func_187226_a(EntityBobbitWorm.class, (DataSerializer)DataSerializers.field_187192_b);
    private float lastAttack = 0.0f;
    private float lastGrab = 0.0f;
    private Vec3d targetPosition;

    public EntityBobbitWorm(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_184644_a(PathNodeType.WATER, 10.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 10.0f));
        HashSet<Class> blackList = new HashSet<Class>();
        blackList.add(EntitySkeleton.class);
        blackList.add(EntityEnderman.class);
        blackList.add(EntityHirschgeist.class);
        blackList.add(EntityJellyfish.class);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, e -> e.field_70130_N < 3.0f && !(e instanceof IMob) && !(e instanceof EntityBobbitWorm) && !blackList.contains(e.getClass())));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE);
    }

    public int setAttackState(int state) {
        this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)state);
        return state;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(10.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    @Nullable
    protected Vec3d getNewTargetPosition() {
        Vec3d pos = RandomPositionGenerator.func_75463_a((EntityCreature)this, (int)20, (int)5);
        if (pos != null && this.isGoodBurrowingPosition(new BlockPos(pos))) {
            return pos;
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
            return new Vec3d((Vec3i)this.func_180425_c().func_177977_b());
        }
        return null;
    }

    public boolean isGoodBurrowingPosition(BlockPos pos) {
        Block below = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        return (below == Blocks.field_150435_aG || below == Blocks.field_150354_m || below == Blocks.field_150351_n || below == Blocks.field_150346_d) && this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u - (double)(this.field_70131_O / 2.0f), this.field_70161_v);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean shouldDismountInWater(Entity entity) {
        return false;
    }

    public void func_70071_h_() {
        Vec3d pos;
        super.func_70071_h_();
        if (!this.field_70171_ac) {
            this.field_70159_w *= (double)0.2f;
            this.field_70179_y *= (double)0.2f;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.08;
            }
            this.field_70181_x *= (double)0.98f;
        } else if (!this.field_70170_p.field_72995_K) {
            if (this.targetPosition != null) {
                this.field_70159_w = (this.targetPosition.field_72450_a - this.field_70165_t) * (double)0.05f;
                this.field_70181_x = (this.targetPosition.field_72448_b - this.field_70163_u) * (double)0.05f;
                this.field_70179_y = (this.targetPosition.field_72449_c - this.field_70161_v) * (double)0.05f;
            }
            if (this.targetPosition != null && Math.sqrt(this.func_180425_c().func_177954_c(this.targetPosition.field_72450_a, this.targetPosition.field_72448_b, this.targetPosition.field_72449_c)) < 1.0) {
                this.field_70159_w *= (double)0.2f;
                this.field_70179_y *= (double)0.2f;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70159_w *= (double)0.2f;
            this.field_70179_y *= (double)0.2f;
            this.field_70181_x *= (double)0.2f;
        }
        boolean goodPos = this.isGoodBurrowingPosition(this.func_180425_c());
        if (this.targetPosition == null && !goodPos && (pos = this.getNewTargetPosition()) != null) {
            this.targetPosition = pos;
        }
        if (this.targetPosition != null && Math.sqrt(this.func_180425_c().func_177954_c(this.targetPosition.field_72450_a, this.targetPosition.field_72448_b, this.targetPosition.field_72449_c)) < 1.0 && !goodPos) {
            this.targetPosition = null;
        }
        if (this.getAttackState() > 0) {
            this.setAttackState(this.getAttackState() - 1);
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70638_az() == null || this.func_70638_az().field_70128_L || this.field_70128_L)) {
            if (this.func_184188_bt().contains(this.func_70638_az())) {
                float time = 30.0f;
                if (this.lastAttack + (time - 20.0f) < (float)this.field_70173_aa) {
                    this.setAttackState(20);
                }
                if (this.lastAttack + time < (float)this.field_70173_aa) {
                    this.func_70652_k((Entity)this.func_70638_az());
                    this.lastAttack = this.field_70173_aa;
                }
            } else if (this.lastGrab + 60.0f < (float)this.field_70173_aa && this.func_70068_e((Entity)this.func_70638_az()) < 5.0) {
                if (!this.func_70638_az().func_190530_aW() && (double)this.func_70638_az().field_70130_N < 2.5 && (double)this.func_70638_az().field_70131_O < 2.5) {
                    this.func_70638_az().func_184205_a((Entity)this, false);
                } else if (!this.func_70638_az().func_190530_aW()) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                this.lastGrab = this.field_70173_aa;
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)this.field_70170_p.func_181545_F();
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 120;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public int getVariantMax() {
        return 2;
    }

    @Override
    protected IVariantTypes getBaseChild() {
        return null;
    }

    @Override
    protected String getContainerName() {
        return "bobbit_worm";
    }
}

