/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import its_meow.betteranimalsplus.common.entity.EntityCoyote;
import its_meow.betteranimalsplus.common.entity.EntityGoat;
import its_meow.betteranimalsplus.common.entity.EntityTameableWithSelectiveTypes;
import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFeralWolf
extends EntityTameableWithSelectiveTypes
implements IMob {
    protected static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityFeralWolf.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityFeralWolf(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.35f, 1.5f);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityPlayer.class, false, Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, e -> e instanceof EntitySheep || e instanceof EntityRabbit));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityVillager.class, false, Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, AbstractIllager.class, false, Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityChicken.class, false, Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityGoat.class, false, Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractSkeleton.class, false));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    public void doHeadDrop() {
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this instanceof EntityCoyote || this.field_70146_Z.nextInt(12) != 0)) {
            ItemStack stack = new ItemStack((Item)HeadTypes.WOLFHEAD.getItem(this.getTypeNumber()));
            this.func_70099_a(stack, 0.5f);
        }
    }

    public boolean isPreventingPlayerRest(EntityPlayer playerIn) {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && !this.func_70909_n() && this.func_70638_az() != null && playerIn.func_70068_e((Entity)this) <= 50.0;
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (!this.func_70909_n() || this.func_70638_az() != null) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            ItemFood itemfood;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFood && (itemfood = (ItemFood)itemstack.func_77973_b()).func_77845_h() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 20.0f) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(itemfood.func_150905_g(itemstack));
                return true;
            }
            if (!(!this.func_152114_e((EntityLivingBase)player) || this.field_70170_p.field_72995_K || this.func_70877_b(itemstack) || itemstack.func_77973_b() instanceof ItemFood && ((ItemFood)itemstack.func_77973_b()).func_77845_h())) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (this.isTamingItem(itemstack.func_77973_b())) {
            boolean wearingPowerHead = false;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (stack.func_77973_b() == Items.field_151144_bL && stack.func_77960_j() == 5) {
                wearingPowerHead = true;
            }
            if (stack.func_77973_b() == ModItems.HIRSCHGEIST_SKULL_WEARABLE) {
                wearingPowerHead = true;
            }
            if (wearingPowerHead) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(100) <= 14 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                        this.func_193101_c(player);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("You cannot tame feral wolves without proving your prowess. Discover a mighty enemy, defeat it, and wear its head. Feral Wolves only bow to the protector of the forests."));
            }
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? 1.0f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.04f : 0.25f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFood && ((ItemFood)stack.func_77973_b()).func_77845_h();
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityFeralWolf entityferalwolf;
            if (target instanceof EntityFeralWolf && (entityferalwolf = (EntityFeralWolf)target).func_70909_n() && entityferalwolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    public int getVariantMax() {
        return 3;
    }

    @Override
    protected IVariantTypes getBaseChild() {
        return null;
    }

    @Override
    protected int[] getTypesFor(Set<BiomeDictionary.Type> types) {
        if (types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new int[]{3};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new int[]{1, 3};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && types.contains(BiomeDictionary.Type.SNOWY)) {
            return new int[]{2, 3};
        }
        if (types.contains(BiomeDictionary.Type.SNOWY) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new int[]{2};
        }
        return new int[]{1, 2, 3};
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getTypeNumber()) {
            case 1: {
                return ModLootTables.WOLF_BLACK;
            }
            case 2: {
                return ModLootTables.WOLF_SNOWY;
            }
            case 3: {
                return ModLootTables.WOLF_TIMBER;
            }
        }
        return super.func_184647_J();
    }

    @Override
    protected String getContainerName() {
        return "feralwolf";
    }
}

