/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.init;

import com.google.common.base.Preconditions;
import its_meow.betteranimalsplus.common.entity.EmptyEntity;
import its_meow.betteranimalsplus.common.entity.EntityLammergeier;
import its_meow.betteranimalsplus.common.entity.projectile.EntityBadgerDirt;
import its_meow.betteranimalsplus.common.entity.projectile.EntityTarantulaHair;
import its_meow.betteranimalsplus.common.item.ItemAdvancementIcon;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHandOfFate;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHead;
import its_meow.betteranimalsplus.common.tileentity.TileEntityTrillium;
import its_meow.betteranimalsplus.init.ModBlocks;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModSoundEvents;
import its_meow.betteranimalsplus.util.EntityContainer;
import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="betteranimalsplus")
public class BetterAnimalsPlusRegistrar {
    public static final Set<Item> HIDE_ITEMS = new HashSet<Item>();
    private static final String LOCALIZE_PREFIX = "betteranimalsplus.";

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Block[]{ModBlocks.trillium, ModBlocks.handoffate});
        for (HeadTypes type : HeadTypes.values()) {
            registry.register(new Block(Material.field_151580_n).setRegistryName("betteranimalsplus", type.name));
            registry.registerAll((IForgeRegistryEntry[])type.getBlocks().toArray(new Block[0]));
        }
        GameRegistry.registerTileEntity(TileEntityTrillium.class, (ResourceLocation)new ResourceLocation(ModBlocks.trillium.getRegistryName() + "tileentity"));
        GameRegistry.registerTileEntity(TileEntityHandOfFate.class, (ResourceLocation)new ResourceLocation(ModBlocks.handoffate.getRegistryName() + "tileentity"));
        GameRegistry.registerTileEntity(TileEntityHead.class, (ResourceLocation)new ResourceLocation("betteranimalsplus", "head"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)ModBlocks.trillium), new ItemBlock((Block)ModBlocks.handoffate)};
        IForgeRegistry registry = event.getRegistry();
        for (ItemBlock itemBlock : items) {
            Block block = itemBlock.func_179223_d();
            ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
            registry.register(itemBlock.setRegistryName(registryName));
        }
        for (HeadTypes headTypes : HeadTypes.values()) {
            Item item = (Item)new Item().setRegistryName("betteranimalsplus", headTypes.name);
            HIDE_ITEMS.add(item);
            registry.register((IForgeRegistryEntry)item);
            registry.registerAll((IForgeRegistryEntry[])headTypes.getItems().toArray(new Item[0]));
        }
        HIDE_ITEMS.add((Item)ModItems.RECORD_CRAB_RAVE);
        registry.registerAll((IForgeRegistryEntry[])new Item[]{ModItems.venisonRaw, ModItems.venisonCooked, ModItems.itemHirschgeistSkullWearable, ModItems.antler, ModItems.goatMilk, ModItems.goatCheese, ModItems.pheasantRaw, ModItems.pheasantCooked, ModItems.WOLF_PELT_SNOWY, ModItems.WOLF_PELT_TIMBER, ModItems.WOLF_PELT_BLACK, ModItems.WOLF_CAPE_CLASSIC, ModItems.WOLF_CAPE_TIMBER, ModItems.WOLF_CAPE_BLACK, ModItems.BEAR_SKIN_BROWN, ModItems.BEAR_SKIN_BLACK, ModItems.BEAR_SKIN_KERMODE, ModItems.BEAR_CAPE_BROWN, ModItems.BEAR_CAPE_BLACK, ModItems.BEAR_CAPE_KERMODE, ModItems.CRAB_MEAT_RAW, ModItems.CRAB_MEAT_COOKED, ModItems.RECORD_CRAB_RAVE, new ItemAdvancementIcon("advancement_icon_jellyfish"), new ItemAdvancementIcon("advancement_icon_jellyfish_cross"), new ItemAdvancementIcon("advancement_icon_goat"), new ItemAdvancementIcon("advancement_icon_shark"), new ItemAdvancementIcon("advancement_icon_lamprey"), new ItemAdvancementIcon("advancement_icon_squirrel"), new ItemAdvancementIcon("advancement_icon_badger")});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        for (EntityContainer container : ModEntities.entityList) {
            BetterAnimalsPlusRegistrar.reg(container);
        }
        EntitySpawnPlacementRegistry.setPlacementType(EntityLammergeier.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_AIR);
        BetterAnimalsPlusRegistrar.register(EntityTarantulaHair.class, "tarantulahair");
        BetterAnimalsPlusRegistrar.register(EntityBadgerDirt.class, "badgerdirt");
        BetterAnimalsPlusRegistrar.register(EmptyEntity.class, "kermodebear");
        if (!ModEntities.entrySet.isEmpty()) {
            for (EntityEntry entityEntry : ModEntities.entrySet) {
                registry.register((IForgeRegistryEntry)entityEntry);
            }
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register(ModSoundEvents.CRAB_RAVE.setRegistryName(new ResourceLocation("betteranimalsplus", "crabrave")));
    }

    public static void reg(EntityContainer c) {
        BetterAnimalsPlusRegistrar.registerWithEgg(c.entityClazz, c.entityName, c.eggColorSolid, c.eggColorSpot, c.type);
    }

    public static void registerWithEgg(Class<? extends Entity> EntityClass, String entityNameIn, int solidColorIn, int spotColorIn, EnumCreatureType typeIn) {
        EntityEntry entry = EntityEntryBuilder.create().entity(EntityClass).id(new ResourceLocation("betteranimalsplus", entityNameIn), ModEntities.modEntities++).name(LOCALIZE_PREFIX + entityNameIn).tracker(64, 1, true).egg(solidColorIn, spotColorIn).build();
        if (typeIn == EnumCreatureType.WATER_CREATURE) {
            EntitySpawnPlacementRegistry.setPlacementType(EntityClass, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        }
        ModEntities.entrySet.add(entry);
    }

    public static void register(Class<? extends Entity> EntityClass, String entityNameIn) {
        EntityEntry entry = EntityEntryBuilder.create().entity(EntityClass).id(new ResourceLocation("betteranimalsplus", entityNameIn), ModEntities.modEntities++).name(LOCALIZE_PREFIX + entityNameIn).tracker(64, 1, true).build();
        ModEntities.entrySet.add(entry);
    }
}

