/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.item.BaitItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AquaFishingRodItem
extends FishingRodItem {
    private final IItemTier tier;
    private final int enchantability;

    public AquaFishingRodItem(IItemTier tier, Item.Properties properties) {
        super(properties);
        this.enchantability = tier == ItemTier.WOOD ? 10 : tier.func_200927_e();
        this.tier = tier;
    }

    public IItemTier getTier() {
        return this.tier;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return this.getDamage(stack) < this.getMaxDamage(stack) && super.showDurabilityBar(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && this.tier == AquacultureAPI.MATS.NEPTUNIUM;
        int damage = this.getDamage(heldStack);
        if (damage >= this.getMaxDamage(heldStack)) {
            return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
        }
        Hook hook = AquaFishingRodItem.getHookType(heldStack);
        if (player.field_71104_cf != null) {
            if (!world.field_72995_K) {
                int currentDamage;
                int lureSpeed = player.field_71104_cf.func_146034_e(heldStack);
                if (lureSpeed >= (currentDamage = this.getMaxDamage(heldStack) - damage)) {
                    lureSpeed = currentDamage;
                }
                if (!isAdminRod) {
                    if (hook != Hooks.EMPTY && hook.getDurabilityChance() > 0.0) {
                        if (field_77697_d.nextDouble() >= hook.getDurabilityChance()) {
                            heldStack.func_96631_a(lureSpeed, world.field_73012_v, null);
                        }
                    } else {
                        heldStack.func_96631_a(lureSpeed, world.field_73012_v, null);
                    }
                }
            }
            player.func_184609_a(hand);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                int lureSpeed = EnchantmentHelper.func_191528_c((ItemStack)heldStack);
                if (this.tier == AquacultureAPI.MATS.NEPTUNIUM) {
                    ++lureSpeed;
                }
                ItemStack bait = AquaFishingRodItem.getBait(heldStack);
                if (!isAdminRod && !bait.func_190926_b()) {
                    lureSpeed += ((BaitItem)bait.func_77973_b()).getLureSpeedModifier();
                }
                lureSpeed = Math.min(5, lureSpeed);
                int luck = EnchantmentHelper.func_191529_b((ItemStack)heldStack);
                if (hook != Hooks.EMPTY && hook.getLuckModifier() > 0) {
                    luck += hook.getLuckModifier();
                }
                world.func_217376_c((Entity)new AquaFishingBobberEntity(player, world, luck, lureSpeed, hook, AquaFishingRodItem.getFishingLine(heldStack), AquaFishingRodItem.getBobber(heldStack), heldStack));
            }
            player.func_184609_a(hand);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        return ActionResult.func_233538_a_((Object)heldStack, (boolean)world.func_201670_d());
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.tier.func_200924_f().test(repair) || super.func_82789_a(toRepair, repair);
    }

    @Nonnull
    public static Hook getHookType(@Nonnull ItemStack fishingRod) {
        ItemStack hookStack;
        Hook hook = Hooks.EMPTY;
        ItemStackHandler rodHandler = (ItemStackHandler)fishingRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)FishingRodEquipmentHandler.EMPTY.getItems());
        if (!fishingRod.func_190926_b() && fishingRod.func_77942_o() && fishingRod.func_77978_p() != null && fishingRod.func_77978_p().func_74764_b("Inventory")) {
            rodHandler.deserializeNBT(fishingRod.func_77978_p().func_74775_l("Inventory"));
        }
        if ((hookStack = rodHandler.getStackInSlot(0)).func_77973_b() instanceof HookItem) {
            hook = ((HookItem)hookStack.func_77973_b()).getHookType();
        }
        return hook;
    }

    @Nonnull
    public static ItemStack getBait(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(1);
    }

    @Nonnull
    public static ItemStack getFishingLine(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(2);
    }

    @Nonnull
    public static ItemStack getBobber(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(3);
    }

    public static ItemStackHandler getHandler(@Nonnull ItemStack fishingRod) {
        ItemStackHandler rodHandler = (ItemStackHandler)fishingRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)FishingRodEquipmentHandler.EMPTY.getItems());
        if (!fishingRod.func_190926_b() && fishingRod.func_77942_o() && fishingRod.func_77978_p() != null && fishingRod.func_77978_p().func_74764_b("Inventory")) {
            rodHandler.deserializeNBT(fishingRod.func_77978_p().func_74775_l("Inventory"));
        }
        return rodHandler;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FishingRodEquipmentHandler(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag tooltipFlag) {
        Hook hook;
        if (this.getDamage(stack) >= this.getMaxDamage(stack)) {
            TranslationTextComponent broken = new TranslationTextComponent("aquaculture.fishing_rod.broken");
            tooltips.add((ITextComponent)broken.func_240703_c_(broken.func_150256_b().func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GRAY)));
        }
        if ((hook = AquaFishingRodItem.getHookType(stack)) != Hooks.EMPTY) {
            TranslationTextComponent hookColor = new TranslationTextComponent(hook.getItem().func_77658_a());
            tooltips.add((ITextComponent)hookColor.func_240703_c_(hookColor.func_150256_b().func_240712_a_(hook.getColor())));
        }
        super.func_77624_a(stack, world, tooltips, tooltipFlag);
    }

    public static class FishingRodEquipmentHandler
    implements ICapabilityProvider {
        public static final FishingRodEquipmentHandler EMPTY = new FishingRodEquipmentHandler(ItemStack.field_190927_a);
        private final LazyOptional<IItemHandler> holder = LazyOptional.of(this::getItems);
        private final ItemStack stack;
        private final ItemStackHandler items = new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.func_77973_b() instanceof HookItem;
                    }
                    case 1: {
                        return stack.func_77973_b() instanceof BaitItem;
                    }
                    case 2: {
                        return stack.func_77973_b().func_206844_a(AquacultureAPI.Tags.FISHING_LINE) && stack.func_77973_b() instanceof IDyeableArmorItem;
                    }
                    case 3: {
                        return stack.func_77973_b().func_206844_a(AquacultureAPI.Tags.BOBBER) && stack.func_77973_b() instanceof IDyeableArmorItem;
                    }
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                CompoundNBT tag = stack.func_196082_o();
                tag.func_218657_a("Inventory", (INBT)this.serializeNBT());
                stack.func_77982_d(tag);
            }
        };

        FishingRodEquipmentHandler(@Nonnull ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.holder.cast() : LazyOptional.empty();
        }

        @Nonnull
        public ItemStackHandler getItems() {
            return this.items;
        }
    }
}

