/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import hunternif.mc.atlas.AntiqueAtlasMod;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public abstract class AbstractMessage<T extends AbstractMessage<T>>
implements IMessage,
IMessageHandler<T, IMessage> {
    protected abstract void read(PacketBuffer var1) throws IOException;

    protected abstract void write(PacketBuffer var1) throws IOException;

    protected abstract void process(EntityPlayer var1, Side var2);

    protected boolean isValidOnSide(Side side) {
        return true;
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.read(new PacketBuffer(buffer));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buffer) {
        try {
            this.write(new PacketBuffer(buffer));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public final IMessage onMessage(T msg, MessageContext ctx) {
        if (!((AbstractMessage)msg).isValidOnSide(ctx.side)) {
            throw new RuntimeException("Invalid side " + ctx.side.name() + " for " + msg.getClass().getSimpleName());
        }
        ((AbstractMessage)msg).process(AntiqueAtlasMod.proxy.getPlayerEntity(ctx), ctx.side);
        return null;
    }

    public static void writeNBT(ByteBuf buffer, NBTTagCompound tag) throws IOException {
        if (tag == null) {
            buffer.writeInt(-1);
        } else {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            buffer.writeInt(compressed.length);
            buffer.writeBytes(compressed);
        }
    }

    public static NBTTagCompound readNBT(ByteBuf buffer) throws IOException {
        int length = buffer.readInt();
        if (length < 0) {
            return null;
        }
        byte[] compressed = new byte[length];
        buffer.readBytes(compressed);
        return CompressedStreamTools.func_152457_a((byte[])compressed, (NBTSizeTracker)new NBTSizeTracker(Integer.MAX_VALUE));
    }

    public static abstract class AbstractServerMessage<T extends AbstractServerMessage<T>>
    extends AbstractMessage<T> {
        @Override
        protected final boolean isValidOnSide(Side side) {
            return side.isServer();
        }
    }

    public static abstract class AbstractClientMessage<T extends AbstractClientMessage<T>>
    extends AbstractMessage<T> {
        @Override
        protected final boolean isValidOnSide(Side side) {
            return side.isClient();
        }
    }
}

